/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class NettyEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":protocol://host:port";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "netty".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "protocol", null, true, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "host", null, true, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "port", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(76);
        props.add("allowDefaultCodec");
        props.add("allowSerializedHeaders");
        props.add("autoAppendDelimiter");
        props.add("backlog");
        props.add("bossCount");
        props.add("bossGroup");
        props.add("bridgeErrorHandler");
        props.add("broadcast");
        props.add("channelGroup");
        props.add("clientInitializerFactory");
        props.add("clientMode");
        props.add("connectTimeout");
        props.add("correlationManager");
        props.add("decoderMaxLineLength");
        props.add("decoders");
        props.add("delimiter");
        props.add("disconnect");
        props.add("disconnectOnNoReply");
        props.add("enabledProtocols");
        props.add("encoders");
        props.add("encoding");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("host");
        props.add("hostnameVerification");
        props.add("keepAlive");
        props.add("keyStoreFile");
        props.add("keyStoreFormat");
        props.add("keyStoreResource");
        props.add("lazyChannelCreation");
        props.add("lazyStartProducer");
        props.add("nativeTransport");
        props.add("needClientAuth");
        props.add("nettyServerBootstrapFactory");
        props.add("networkInterface");
        props.add("noReplyLogLevel");
        props.add("options");
        props.add("passphrase");
        props.add("port");
        props.add("producerPoolBlockWhenExhausted");
        props.add("producerPoolEnabled");
        props.add("producerPoolMaxIdle");
        props.add("producerPoolMaxTotal");
        props.add("producerPoolMaxWait");
        props.add("producerPoolMinEvictableIdle");
        props.add("producerPoolMinIdle");
        props.add("protocol");
        props.add("receiveBufferSize");
        props.add("receiveBufferSizePredictor");
        props.add("reconnect");
        props.add("reconnectInterval");
        props.add("requestTimeout");
        props.add("reuseAddress");
        props.add("reuseChannel");
        props.add("securityProvider");
        props.add("sendBufferSize");
        props.add("serverClosedChannelExceptionCaughtLogLevel");
        props.add("serverExceptionCaughtLogLevel");
        props.add("serverInitializerFactory");
        props.add("ssl");
        props.add("sslClientCertHeaders");
        props.add("sslContextParameters");
        props.add("sslHandler");
        props.add("sync");
        props.add("synchronous");
        props.add("tcpNoDelay");
        props.add("textline");
        props.add("transferExchange");
        props.add("trustStoreFile");
        props.add("trustStoreResource");
        props.add("udpByteArrayCodec");
        props.add("udpConnectionlessSending");
        props.add("useByteBuf");
        props.add("usingExecutorService");
        props.add("workerCount");
        props.add("workerGroup");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(1);
        secretProps.add("passphrase");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        HashSet<String> prefixes = new HashSet<String>(1);
        prefixes.add("option.");
        MULTI_VALUE_PREFIXES = Collections.unmodifiableSet(prefixes);
    }
}

