/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.net.InetSocketAddress;
import java.util.List;
import org.apache.camel.component.netty.codec.DelegateByteArrayEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class DatagramPacketByteArrayEncoder
extends MessageToMessageEncoder<AddressedEnvelope<Object, InetSocketAddress>> {
    private static final Logger LOG = LoggerFactory.getLogger(DatagramPacketByteArrayEncoder.class);
    private DelegateByteArrayEncoder delegateEncoder = new DelegateByteArrayEncoder();

    protected void encode(ChannelHandlerContext ctx, AddressedEnvelope<Object, InetSocketAddress> msg, List<Object> out) throws Exception {
        if (msg.content() instanceof byte[]) {
            this.delegateEncoder.encode(ctx, (byte[])msg.content(), out);
            ByteBuf buf = (ByteBuf)out.remove(out.size() - 1);
            DefaultAddressedEnvelope addressedEnvelop = new DefaultAddressedEnvelope((Object)buf.retain(), msg.recipient(), msg.sender());
            out.add(addressedEnvelop);
        } else {
            LOG.debug("Ignoring message content as it is not a byte[] instance.");
        }
    }
}

