/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quartz;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.StartupListener;
import org.apache.camel.component.quartz.QuartzEndpoint;
import org.apache.camel.component.quartz.QuartzHelper;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResourceHelper;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzComponent
extends DefaultComponent
implements StartupListener {
    private static final Logger LOG = LoggerFactory.getLogger(QuartzComponent.class);
    private Scheduler scheduler;
    private final List<JobToAdd> jobsToAdd = new ArrayList<JobToAdd>();
    private SchedulerFactory factory;
    private Properties properties;
    private String propertiesFile;
    private int startDelayedSeconds;
    private boolean autoStartScheduler = true;
    private boolean enableJmx = true;

    public QuartzComponent() {
    }

    public QuartzComponent(CamelContext context) {
        super(context);
    }

    protected QuartzEndpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        SimpleTrigger trigger;
        String name;
        String group;
        URI u = new URI(uri);
        String path = ObjectHelper.after((String)u.getPath(), (String)"/");
        String host = u.getHost();
        String cron = (String)this.getAndRemoveParameter(parameters, "cron", String.class);
        Boolean fireNow = (Boolean)this.getAndRemoveParameter(parameters, "fireNow", Boolean.class, Boolean.FALSE);
        Integer startDelayedSeconds = (Integer)this.getAndRemoveParameter(parameters, "startDelayedSeconds", Integer.class);
        if (startDelayedSeconds != null) {
            if (this.scheduler.isStarted()) {
                LOG.warn("A Quartz job is already started. Cannot apply the 'startDelayedSeconds' configuration!");
            } else if (this.startDelayedSeconds != 0 && this.startDelayedSeconds != startDelayedSeconds) {
                LOG.warn("A Quartz job is already configured with a different 'startDelayedSeconds' configuration! All Quartz jobs must share the same 'startDelayedSeconds' configuration! Cannot apply the 'startDelayedSeconds' configuration!");
            } else {
                this.startDelayedSeconds = startDelayedSeconds;
            }
        }
        if (host == null && (host = ObjectHelper.before((String)remaining, (String)"/")) == null) {
            host = remaining;
        }
        if (ObjectHelper.isNotEmpty((Object)path) && ObjectHelper.isNotEmpty((Object)host)) {
            group = host;
            name = path;
        } else {
            group = "Camel";
            name = host;
        }
        Map triggerParameters = IntrospectionSupport.extractProperties(parameters, (String)"trigger.");
        Map jobParameters = IntrospectionSupport.extractProperties(parameters, (String)"job.");
        boolean stateful = "true".equals(parameters.get("stateful"));
        if (!this.isClustered() && !stateful && (trigger = this.getScheduler().getTrigger(name, group)) != null) {
            String msg = "A Quartz job already exists with the name/group: " + name + "/" + group;
            throw new IllegalArgumentException(msg);
        }
        if (ObjectHelper.isNotEmpty((Object)cron)) {
            cron = QuartzComponent.encodeCronExpression(cron);
            trigger = this.createCronTrigger(cron);
        } else {
            String intervalString;
            trigger = new SimpleTrigger();
            if (fireNow.booleanValue() && (intervalString = (String)triggerParameters.get("repeatInterval")) != null) {
                long interval = Long.valueOf(intervalString);
                trigger.setStartTime(new Date(System.currentTimeMillis() - interval));
            }
        }
        QuartzEndpoint answer = new QuartzEndpoint(uri, this);
        this.setProperties(answer.getJobDetail(), jobParameters);
        if (cron != null) {
            answer.getJobDetail().getJobDataMap().put("CamelQuartzTriggerType", "cron");
            answer.getJobDetail().getJobDataMap().put("CamelQuartzTriggerCronExpression", cron);
        } else {
            Integer counter;
            answer.getJobDetail().getJobDataMap().put("CamelQuartzTriggerType", "simple");
            Long interval = (Long)this.getCamelContext().getTypeConverter().convertTo(Long.class, triggerParameters.get("repeatInterval"));
            if (interval != null) {
                answer.getJobDetail().getJobDataMap().put((Object)"CamelQuartzTriggerSimpleRepeatInterval", (Object)interval);
            }
            if ((counter = (Integer)this.getCamelContext().getTypeConverter().convertTo(Integer.class, triggerParameters.get("repeatCount"))) != null) {
                answer.getJobDetail().getJobDataMap().put((Object)"CamelQuartzTriggerSimpleRepeatCounter", (Object)counter);
            }
        }
        this.setProperties(trigger, triggerParameters);
        trigger.setName(name);
        trigger.setGroup(group);
        answer.setTrigger((Trigger)trigger);
        return answer;
    }

    protected CronTrigger createCronTrigger(String path) throws ParseException {
        CronTrigger cron = new CronTrigger();
        cron.setCronExpression(path);
        return cron;
    }

    private static String encodeCronExpression(String path) {
        return path.replaceAll("\\+", " ");
    }

    public void onCamelContextStarted(CamelContext camelContext, boolean alreadyStarted) throws Exception {
        if (this.scheduler != null) {
            String uid = QuartzHelper.getQuartzContextName(camelContext);
            this.scheduler.getContext().put((Object)("CamelQuartzCamelContext-" + uid), (Object)camelContext);
        }
        if (!this.isAutoStartScheduler()) {
            LOG.info("QuartzComponent configured to not auto start Quartz scheduler.");
            return;
        }
        this.startScheduler();
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.scheduler == null) {
            this.scheduler = this.getScheduler();
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.scheduler != null) {
            AtomicInteger number = (AtomicInteger)this.scheduler.getContext().get((Object)"CamelJobs");
            if (number != null && number.get() > 0) {
                LOG.info("Cannot shutdown Quartz scheduler: " + this.scheduler.getSchedulerName() + " as there are still " + number.get() + " jobs registered.");
            } else {
                LOG.info("There are no more jobs registered, so shutting down Quartz scheduler: " + this.scheduler.getSchedulerName());
                this.scheduler.shutdown();
                this.scheduler = null;
            }
        }
    }

    public void addJob(JobDetail job, Trigger trigger) throws SchedulerException {
        if (this.scheduler == null) {
            this.jobsToAdd.add(new JobToAdd(job, trigger));
        } else {
            this.doAddJob(job, trigger);
        }
    }

    private void doAddJob(JobDetail job, Trigger trigger) throws SchedulerException {
        Trigger existingTrigger = this.getScheduler().getTrigger(trigger.getName(), trigger.getGroup());
        if (existingTrigger == null) {
            LOG.debug("Adding job using trigger: {}/{}", (Object)trigger.getGroup(), (Object)trigger.getName());
            this.getScheduler().scheduleJob(job, trigger);
        } else if (this.hasTriggerChanged(existingTrigger, trigger)) {
            LOG.debug("Trigger: {}/{} already exists and will be updated by Quartz.", (Object)trigger.getGroup(), (Object)trigger.getName());
            trigger.setStartTime(new Date());
            this.scheduler.unscheduleJob(trigger.getName(), trigger.getGroup());
            this.scheduler.addJob(job, true);
            trigger.setJobName(job.getName());
            trigger.setJobGroup(job.getGroup());
            this.scheduler.scheduleJob(trigger);
        } else if (!this.isClustered()) {
            LOG.debug("Trigger: {}/{} already exists and will be resumed by Quartz.", (Object)trigger.getGroup(), (Object)trigger.getName());
            trigger.setStartTime(new Date());
            this.scheduler.unscheduleJob(trigger.getName(), trigger.getGroup());
            this.scheduler.addJob(job, true);
            trigger.setJobName(job.getName());
            trigger.setJobGroup(job.getGroup());
            this.scheduler.scheduleJob(trigger);
        } else {
            LOG.debug("Trigger: {}/{} already exists and is already scheduled by clustered JobStore.", (Object)trigger.getGroup(), (Object)trigger.getName());
        }
        QuartzComponent.incrementJobCounter(this.getScheduler());
    }

    private boolean hasTriggerChanged(Trigger oldTrigger, Trigger newTrigger) {
        if (oldTrigger instanceof CronTrigger && oldTrigger.equals((Object)newTrigger)) {
            CronTrigger oldCron = (CronTrigger)oldTrigger;
            CronTrigger newCron = (CronTrigger)newTrigger;
            return !oldCron.getCronExpression().equals(newCron.getCronExpression());
        }
        return !newTrigger.equals((Object)oldTrigger);
    }

    public void pauseJob(Trigger trigger) throws SchedulerException {
        if (this.isClustered()) {
            LOG.debug("Cannot pause job using trigger: {}/{} as the JobStore is clustered.", (Object)trigger.getGroup(), (Object)trigger.getName());
        } else {
            LOG.debug("Pausing job using trigger: {}/{}", (Object)trigger.getGroup(), (Object)trigger.getName());
            this.getScheduler().pauseTrigger(trigger.getName(), trigger.getGroup());
            this.getScheduler().pauseJob(trigger.getName(), trigger.getGroup());
        }
        QuartzComponent.decrementJobCounter(this.getScheduler());
    }

    public void deleteJob(String name, String group) throws SchedulerException {
        if (this.isClustered()) {
            LOG.debug("Cannot delete job using trigger: {}/{} as the JobStore is clustered.", (Object)group, (Object)name);
        } else {
            Trigger trigger = this.getScheduler().getTrigger(name, group);
            if (trigger != null) {
                LOG.debug("Deleting job using trigger: {}/{}", (Object)group, (Object)name);
                this.getScheduler().unscheduleJob(name, group);
            }
        }
    }

    public void shutdownScheduler() throws SchedulerException {
        if (this.scheduler != null) {
            LOG.info("Forcing shutdown of Quartz scheduler: " + this.scheduler.getSchedulerName());
            this.scheduler.shutdown();
            this.scheduler = null;
        }
    }

    public boolean isClustered() throws SchedulerException {
        try {
            return this.getScheduler().getMetaData().isJobStoreClustered();
        }
        catch (NoSuchMethodError e) {
            LOG.debug("Job clustering is only supported since Quartz 1.7, isClustered returning false");
            return false;
        }
    }

    public void startScheduler() throws SchedulerException {
        for (JobToAdd add : this.jobsToAdd) {
            this.doAddJob(add.getJob(), add.getTrigger());
        }
        this.jobsToAdd.clear();
        if (!this.getScheduler().isStarted()) {
            if (this.getStartDelayedSeconds() > 0) {
                LOG.info("Starting Quartz scheduler: " + this.getScheduler().getSchedulerName() + " delayed: " + this.getStartDelayedSeconds() + " seconds.");
                try {
                    this.getScheduler().startDelayed(this.getStartDelayedSeconds());
                }
                catch (NoSuchMethodError e) {
                    LOG.warn("Your version of Quartz is too old to support delayed startup! Starting Quartz scheduler immediately : " + this.getScheduler().getSchedulerName());
                    this.getScheduler().start();
                }
            } else {
                LOG.info("Starting Quartz scheduler: " + this.getScheduler().getSchedulerName());
                this.getScheduler().start();
            }
        }
    }

    public SchedulerFactory getFactory() throws SchedulerException {
        if (this.factory == null) {
            this.factory = this.createSchedulerFactory();
        }
        return this.factory;
    }

    public void setFactory(SchedulerFactory factory) {
        this.factory = factory;
    }

    public synchronized Scheduler getScheduler() throws SchedulerException {
        if (this.scheduler == null) {
            this.scheduler = this.createScheduler();
        }
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getPropertiesFile() {
        return this.propertiesFile;
    }

    public void setPropertiesFile(String propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    public int getStartDelayedSeconds() {
        return this.startDelayedSeconds;
    }

    public void setStartDelayedSeconds(int startDelayedSeconds) {
        this.startDelayedSeconds = startDelayedSeconds;
    }

    public boolean isAutoStartScheduler() {
        return this.autoStartScheduler;
    }

    public void setAutoStartScheduler(boolean autoStartScheduler) {
        this.autoStartScheduler = autoStartScheduler;
    }

    public boolean isEnableJmx() {
        return this.enableJmx;
    }

    public void setEnableJmx(boolean enableJmx) {
        this.enableJmx = enableJmx;
    }

    protected Properties loadProperties() throws SchedulerException {
        Properties answer = this.getProperties();
        if (answer == null && this.getPropertiesFile() != null) {
            LOG.info("Loading Quartz properties file from: {}", (Object)this.getPropertiesFile());
            InputStream is = null;
            try {
                is = ResourceHelper.resolveMandatoryResourceAsInputStream((ClassResolver)this.getCamelContext().getClassResolver(), (String)this.getPropertiesFile());
                answer = new Properties();
                answer.load(is);
            }
            catch (IOException e) {
                try {
                    throw new SchedulerException("Error loading Quartz properties file: " + this.getPropertiesFile(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOHelper.close(is);
                    throw throwable;
                }
            }
            IOHelper.close((Closeable)is);
        }
        return answer;
    }

    protected SchedulerFactory createSchedulerFactory() throws SchedulerException {
        StdSchedulerFactory answer;
        Properties prop = this.loadProperties();
        if (prop != null) {
            prop.put("org.quartz.scheduler.skipUpdateCheck", "true");
            String instName = this.createInstanceName(prop);
            prop.setProperty("org.quartz.scheduler.instanceName", instName);
            if (this.enableJmx && !prop.containsKey("org.quartz.scheduler.jmx.export")) {
                LOG.info("Setting org.quartz.scheduler.jmx.export=true to ensure QuartzScheduler(s) will be enlisted in JMX.");
                prop.put("org.quartz.scheduler.jmx.export", "true");
            }
            answer = new StdSchedulerFactory(prop);
        } else {
            InputStream is = StdSchedulerFactory.class.getClassLoader().getResourceAsStream("org/quartz/quartz.properties");
            if (is == null) {
                throw new SchedulerException("Quartz properties file not found in classpath: org/quartz/quartz.properties");
            }
            prop = new Properties();
            try {
                prop.load(is);
            }
            catch (IOException e) {
                throw new SchedulerException("Error loading Quartz properties file from classpath: org/quartz/quartz.properties", (Throwable)e);
            }
            finally {
                IOHelper.close((Closeable)is);
            }
            String instName = this.createInstanceName(prop);
            prop.setProperty("org.quartz.scheduler.instanceName", instName);
            prop.put("org.quartz.scheduler.skipUpdateCheck", "true");
            if (this.enableJmx && !prop.containsKey("org.quartz.scheduler.jmx.export")) {
                prop.put("org.quartz.scheduler.jmx.export", "true");
                LOG.info("Setting org.quartz.scheduler.jmx.export=true to ensure QuartzScheduler(s) will be enlisted in JMX.");
            }
            answer = new StdSchedulerFactory(prop);
        }
        if (LOG.isDebugEnabled()) {
            String name = prop.getProperty("org.quartz.scheduler.instanceName");
            LOG.debug("Creating SchedulerFactory: {} with properties: {}", (Object)name, (Object)prop);
        }
        return answer;
    }

    protected String createInstanceName(Properties prop) {
        String instName = prop.getProperty("org.quartz.scheduler.instanceName");
        String identity = QuartzHelper.getQuartzContextName(this.getCamelContext());
        if (identity != null) {
            instName = instName == null ? "scheduler-" + identity : instName + "-" + identity;
        }
        return instName;
    }

    protected Scheduler createScheduler() throws SchedulerException {
        Scheduler scheduler = this.getFactory().getScheduler();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using SchedulerFactory {} to get/create Scheduler {}({})", new Object[]{this.getFactory(), scheduler, ObjectHelper.getIdentityHashCode((Object)scheduler)});
        }
        String uid = QuartzHelper.getQuartzContextName(this.getCamelContext());
        scheduler.getContext().put((Object)("CamelQuartzCamelContext-" + uid), (Object)this.getCamelContext());
        AtomicInteger number = (AtomicInteger)scheduler.getContext().get((Object)"CamelJobs");
        if (number == null) {
            number = new AtomicInteger(0);
            scheduler.getContext().put((Object)"CamelJobs", (Object)number);
        }
        return scheduler;
    }

    private static void decrementJobCounter(Scheduler scheduler) throws SchedulerException {
        AtomicInteger number = (AtomicInteger)scheduler.getContext().get((Object)"CamelJobs");
        if (number != null) {
            number.decrementAndGet();
        }
    }

    private static void incrementJobCounter(Scheduler scheduler) throws SchedulerException {
        AtomicInteger number = (AtomicInteger)scheduler.getContext().get((Object)"CamelJobs");
        if (number != null) {
            number.incrementAndGet();
        }
    }

    private static final class JobToAdd {
        private final JobDetail job;
        private final Trigger trigger;

        private JobToAdd(JobDetail job, Trigger trigger) {
            this.job = job;
            this.trigger = trigger;
        }

        public JobDetail getJob() {
            return this.job;
        }

        public Trigger getTrigger() {
            return this.trigger;
        }
    }
}

