/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quartz;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.camel.component.quartz.QuartzComponent;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.quartz.JobExecutionContext;
import org.quartz.Scheduler;
import org.quartz.SchedulerMetaData;

@DevConsole(value="quartz")
public class QuartzConsole
extends AbstractDevConsole {
    public QuartzConsole() {
        super("camel", "quartz", "Quartz", "Quartz Scheduler");
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        QuartzComponent quartz = (QuartzComponent)this.getCamelContext().getComponent("quartz", QuartzComponent.class);
        if (quartz != null) {
            Scheduler scheduler = quartz.getScheduler();
            try {
                sb.append(String.format("    Scheduler Name: %s\n", scheduler.getSchedulerName()));
                sb.append(String.format("    Scheduler Id: %s\n", scheduler.getSchedulerInstanceId()));
                SchedulerMetaData meta = scheduler.getMetaData();
                if (meta != null) {
                    sb.append(String.format("    Quartz Version: %s\n", meta.getVersion()));
                    String since = SimpleDateFormat.getDateTimeInstance().format(meta.getRunningSince());
                    sb.append(String.format("    Running Since: %s\n", since));
                    sb.append(String.format("    Total Counter: %s\n", meta.getNumberOfJobsExecuted()));
                    sb.append(String.format("    Started: %s\n", meta.isStarted()));
                    sb.append(String.format("    Shutdown: %s\n", meta.isShutdown()));
                    sb.append(String.format("    In Standby Mode: %s\n", meta.isInStandbyMode()));
                    sb.append(String.format("    Thread Pool Class: %s\n", meta.getThreadPoolClass().getName()));
                    sb.append(String.format("    Thread Pool Size: %d\n", meta.getThreadPoolSize()));
                    sb.append(String.format("    Job Store Class: %s\n", meta.getJobStoreClass().getName()));
                    sb.append(String.format("    Job Store Clustered: %s\n", meta.isJobStoreClustered()));
                    sb.append(String.format("    Job Store Supports Persistence: %s\n", meta.isJobStoreSupportsPersistence()));
                }
                List jobs = scheduler.getCurrentlyExecutingJobs();
                sb.append(String.format("    Currently Executing Jobs: %d\n", jobs.size()));
                if (!jobs.isEmpty()) {
                    sb.append("\n");
                    sb.append("Jobs:\n");
                    sb.append("\n");
                    for (JobExecutionContext job : jobs) {
                        Date d;
                        String routeId;
                        sb.append(String.format("        Job Id: %s\n", job.getFireInstanceId()));
                        String type = (String)job.getJobDetail().getJobDataMap().get((Object)"CamelQuartzTriggerType");
                        sb.append(String.format("        Trigger Type: %s\n", type));
                        String cron = (String)job.getJobDetail().getJobDataMap().get((Object)"CamelQuartzTriggerCronExpression");
                        if (cron != null) {
                            sb.append(String.format("        Cron: %s\n", cron));
                        }
                        if ((routeId = (String)job.getJobDetail().getJobDataMap().get((Object)"routeId")) != null) {
                            sb.append(String.format("        Route Id: %s\n", routeId));
                        }
                        String uri = (String)job.getJobDetail().getJobDataMap().get((Object)"CamelQuartzEndpoint");
                        if (cron != null) {
                            sb.append(String.format("        Endpoint Uri: %s\n", uri));
                        }
                        if ((d = job.getTrigger().getPreviousFireTime()) != null) {
                            sb.append(String.format("        Prev Fire Time: %s\n", SimpleDateFormat.getDateTimeInstance().format(d)));
                        }
                        if ((d = job.getFireTime()) != null) {
                            sb.append(String.format("        Fire Time: %s\n", SimpleDateFormat.getDateTimeInstance().format(d)));
                        }
                        if ((d = job.getTrigger().getNextFireTime()) != null) {
                            sb.append(String.format("        Next Fire Time: %s\n", SimpleDateFormat.getDateTimeInstance().format(d)));
                        }
                        if ((d = job.getTrigger().getFinalFireTime()) != null) {
                            sb.append(String.format("        Final Fire Time: %s\n", SimpleDateFormat.getDateTimeInstance().format(d)));
                        }
                        sb.append(String.format("        Recovering: %s\n", job.isRecovering()));
                        sb.append(String.format("        Refire Count: %s\n", job.getRefireCount()));
                        sb.append(String.format("        Misfire Instruction: %s\n", job.getTrigger().getMisfireInstruction()));
                        sb.append("\n");
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    protected Map<String, Object> doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        QuartzComponent quartz = (QuartzComponent)this.getCamelContext().getComponent("quartz", QuartzComponent.class);
        if (quartz != null) {
            Scheduler scheduler = quartz.getScheduler();
            try {
                root.put((Object)"schedulerName", (Object)scheduler.getSchedulerName());
                root.put((Object)"schedulerInstanceId", (Object)scheduler.getSchedulerInstanceId());
                SchedulerMetaData meta = scheduler.getMetaData();
                if (meta != null) {
                    root.put((Object)"quartzVersion", (Object)meta.getVersion());
                    root.put((Object)"runningSince", (Object)meta.getRunningSince().getTime());
                    root.put((Object)"totalCounter", (Object)meta.getNumberOfJobsExecuted());
                    root.put((Object)"started", (Object)meta.isStarted());
                    root.put((Object)"shutdown", (Object)meta.isShutdown());
                    root.put((Object)"inStandbyMode", (Object)meta.isInStandbyMode());
                    root.put((Object)"threadPoolClass", (Object)meta.getThreadPoolClass().getName());
                    root.put((Object)"threadPoolSize", (Object)meta.getThreadPoolSize());
                    root.put((Object)"jpbStoreClass", (Object)meta.getJobStoreClass().getName());
                    root.put((Object)"jpbStoreClustered", (Object)meta.isJobStoreClustered());
                    root.put((Object)"jpbStoreSupportsPersistence", (Object)meta.isJobStoreSupportsPersistence());
                }
                List jobs = scheduler.getCurrentlyExecutingJobs();
                root.put((Object)"currentExecutingJobs", (Object)jobs.size());
                if (!jobs.isEmpty()) {
                    JsonArray arr = new JsonArray();
                    root.put((Object)"jobs", (Object)arr);
                    for (JobExecutionContext job : jobs) {
                        Date d;
                        String routeId;
                        JsonObject jo = new JsonObject();
                        jo.put((Object)"jobId", (Object)job.getFireInstanceId());
                        String type = (String)job.getJobDetail().getJobDataMap().get((Object)"CamelQuartzTriggerType");
                        jo.put((Object)"triggerType", (Object)type);
                        String cron = (String)job.getJobDetail().getJobDataMap().get((Object)"CamelQuartzTriggerCronExpression");
                        if (cron != null) {
                            jo.put((Object)"cron", (Object)cron);
                        }
                        if ((routeId = (String)job.getJobDetail().getJobDataMap().get((Object)"routeId")) != null) {
                            jo.put((Object)"routeId", (Object)routeId);
                        }
                        String uri = (String)job.getJobDetail().getJobDataMap().get((Object)"CamelQuartzEndpoint");
                        if (cron != null) {
                            jo.put((Object)"uri", (Object)uri);
                        }
                        if ((d = job.getTrigger().getPreviousFireTime()) != null) {
                            jo.put((Object)"prevFireTime", (Object)d.getTime());
                        }
                        if ((d = job.getFireTime()) != null) {
                            jo.put((Object)"fireTime", (Object)d.getTime());
                        }
                        if ((d = job.getTrigger().getNextFireTime()) != null) {
                            jo.put((Object)"nextFireTime", (Object)d.getTime());
                        }
                        if ((d = job.getTrigger().getFinalFireTime()) != null) {
                            jo.put((Object)"finalFireTime", (Object)d.getTime());
                        }
                        jo.put((Object)"recovering", (Object)job.isRecovering());
                        jo.put((Object)"refireCount", (Object)job.getRefireCount());
                        jo.put((Object)"misfireInstruction", (Object)job.getTrigger().getMisfireInstruction());
                        arr.add((Object)jo);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return root;
    }
}

