/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quickfixj;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultConsumer;
import quickfix.MessageUtils;
import quickfix.Session;
import quickfix.SessionID;

public class QuickfixjConsumer
extends DefaultConsumer {
    public QuickfixjConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    public void onExchange(Exchange exchange) throws Exception {
        if (this.isStarted()) {
            try {
                this.getProcessor().process(exchange);
                if (exchange.getPattern().isOutCapable() && exchange.hasOut()) {
                    this.sendOutMessage(exchange);
                }
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
            }
        }
    }

    private void sendOutMessage(Exchange exchange) {
        try {
            SessionID messageSessionID;
            Session session;
            Message camelMessage = exchange.getOut();
            quickfix.Message quickfixjMessage = (quickfix.Message)camelMessage.getBody(quickfix.Message.class);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Sending FIX message reply: " + quickfixjMessage.toString());
            }
            if ((session = this.getSession(messageSessionID = MessageUtils.getReverseSessionID((quickfix.Message)((quickfix.Message)exchange.getIn().getBody(quickfix.Message.class))))) == null) {
                throw new IllegalStateException("Unknown session: " + messageSessionID);
            }
            session.send(quickfixjMessage);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
    }

    Session getSession(SessionID messageSessionID) {
        return Session.lookupSession((SessionID)messageSessionID);
    }
}

