/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest.openapi;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.StartupStep;
import org.apache.camel.component.platform.http.spi.PlatformHttpConsumerAware;
import org.apache.camel.component.rest.openapi.RestOpenApiConsumerPath;
import org.apache.camel.component.rest.openapi.RestOpenApiEndpoint;
import org.apache.camel.component.rest.openapi.RestOpenapiProcessorStrategy;
import org.apache.camel.http.base.HttpHelper;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeAware;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.RestConsumerContextPathMatcher;
import org.apache.camel.support.http.RestUtil;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.apache.camel.support.processor.RestBindingAdvice;
import org.apache.camel.support.processor.RestBindingAdviceFactory;
import org.apache.camel.support.processor.RestBindingConfiguration;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestOpenApiProcessor
extends DelegateAsyncProcessor
implements CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(RestOpenApiProcessor.class);
    private static final List<String> METHODS = Arrays.asList("GET", "HEAD", "POST", "PUT", "DELETE", "PATCH");
    private CamelContext camelContext;
    private final RestOpenApiEndpoint endpoint;
    private final OpenAPI openAPI;
    private final String basePath;
    private final String apiContextPath;
    private final List<RestConsumerContextPathMatcher.ConsumerPath<Operation>> paths = new ArrayList<RestConsumerContextPathMatcher.ConsumerPath<Operation>>();
    private final RestOpenapiProcessorStrategy restOpenapiProcessorStrategy;
    private final AtomicBoolean packageScanInit = new AtomicBoolean();
    private final Set<Class<?>> scannedClasses = new HashSet();
    private PlatformHttpConsumerAware platformHttpConsumer;

    public RestOpenApiProcessor(RestOpenApiEndpoint endpoint, OpenAPI openAPI, String basePath, String apiContextPath, Processor processor, RestOpenapiProcessorStrategy restOpenapiProcessorStrategy) {
        super(processor);
        this.endpoint = endpoint;
        this.basePath = basePath;
        this.apiContextPath = apiContextPath != null && !apiContextPath.startsWith("/") ? "/" + apiContextPath : apiContextPath;
        this.openAPI = openAPI;
        this.restOpenapiProcessorStrategy = restOpenapiProcessorStrategy;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public PlatformHttpConsumerAware getPlatformHttpConsumer() {
        return this.platformHttpConsumer;
    }

    public void setPlatformHttpConsumer(PlatformHttpConsumerAware platformHttpConsumer) {
        this.platformHttpConsumer = platformHttpConsumer;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        String verb;
        RestConsumerContextPathMatcher.ConsumerPath m;
        String uri = (String)exchange.getMessage().getHeader("CamelHttpUri", String.class);
        if (uri != null) {
            uri = URISupport.stripQuery((String)uri);
        }
        if (uri != null && uri.startsWith(this.basePath)) {
            uri = uri.substring(this.basePath.length());
        }
        if ((m = RestConsumerContextPathMatcher.matchBestPath((String)(verb = (String)exchange.getMessage().getHeader("CamelHttpMethod", String.class)), (String)uri, this.paths)) instanceof RestOpenApiConsumerPath) {
            RestOpenApiConsumerPath rcp = (RestOpenApiConsumerPath)m;
            Operation o = rcp.getConsumer();
            RestConfiguration config = this.camelContext.getRestConfiguration();
            RestConfiguration.RestBindingMode bindingMode = config.getBindingMode();
            HttpHelper.evalPlaceholders((Map)exchange.getMessage().getHeaders(), (String)uri, (String)rcp.getConsumerPath());
            if (this.endpoint.isClientRequestValidation() && this.isInvalidClientRequest(exchange, callback, o, bindingMode)) {
                return true;
            }
            return this.restOpenapiProcessorStrategy.process(o, verb, uri, rcp.getBinding(), exchange, callback);
        }
        if (uri != null && uri.equals(this.apiContextPath)) {
            return this.restOpenapiProcessorStrategy.processApiSpecification(this.endpoint.getSpecificationUri(), exchange, callback);
        }
        String contextPath = uri;
        List<String> allow = METHODS.stream().filter(v -> RestConsumerContextPathMatcher.matchBestPath((String)v, (String)contextPath, this.paths) != null).toList();
        if (allow.isEmpty()) {
            exchange.getMessage().setHeader("CamelHttpResponseCode", (Object)404);
        } else {
            exchange.getMessage().setHeader("CamelHttpResponseCode", (Object)405);
            exchange.getMessage().setHeader("Allow", (Object)String.join((CharSequence)", ", allow));
        }
        exchange.setRouteStop(true);
        callback.done(true);
        return true;
    }

    protected boolean isInvalidClientRequest(Exchange exchange, AsyncCallback callback, Operation o, RestConfiguration.RestBindingMode bindingMode) {
        Object c;
        boolean isXml = false;
        boolean isJson = false;
        String contentType = ExchangeHelper.getContentType((Exchange)exchange);
        if (contentType != null) {
            isXml = contentType.toLowerCase(Locale.ENGLISH).contains("xml");
            isJson = contentType.toLowerCase(Locale.ENGLISH).contains("json");
        }
        String accept = (String)exchange.getMessage().getHeader("Accept", String.class);
        String consumes = this.endpoint.getConsumes();
        String produces = this.endpoint.getProduces();
        if (o.getRequestBody() != null && (c = o.getRequestBody().getContent()) != null) {
            consumes = c.keySet().stream().sorted().collect(Collectors.joining(","));
        }
        if (o.getResponses() != null) {
            for (ApiResponse a : o.getResponses().values()) {
                Content c2 = a.getContent();
                if (c2 == null) continue;
                produces = c2.keySet().stream().sorted().collect(Collectors.joining(","));
            }
        }
        if (!isXml && !isJson) {
            isXml = consumes != null && consumes.toLowerCase(Locale.ENGLISH).contains("xml");
            boolean bl = isJson = consumes != null && consumes.toLowerCase(Locale.ENGLISH).contains("json");
        }
        if (exchange.getContext().isUseDataType().booleanValue() && exchange.getIn() instanceof DataTypeAware && (isJson || isXml)) {
            ((DataTypeAware)exchange.getIn()).setDataType(new DataType(isJson ? "json" : "xml"));
        }
        if (!RestUtil.isValidOrAcceptedContentType((String)consumes, (String)contentType)) {
            LOG.trace("Consuming content type does not match contentType header {}. Stopping routing.", (Object)contentType);
            exchange.getMessage().setHeader("CamelHttpResponseCode", (Object)415);
            exchange.getMessage().setBody(null);
            exchange.setRouteStop(true);
            callback.done(true);
            return true;
        }
        if (!RestUtil.isValidOrAcceptedContentType((String)produces, (String)accept)) {
            LOG.trace("Produced content type does not match accept header {}. Stopping routing.", (Object)contentType);
            exchange.getMessage().setHeader("CamelHttpResponseCode", (Object)406);
            exchange.getMessage().setBody(null);
            exchange.setRouteStop(true);
            callback.done(true);
            return true;
        }
        if (!(isJson &= bindingMode.equals((Object)RestConfiguration.RestBindingMode.auto) || bindingMode.equals((Object)RestConfiguration.RestBindingMode.json) || bindingMode.equals((Object)RestConfiguration.RestBindingMode.json_xml)) && !(isXml &= bindingMode.equals((Object)RestConfiguration.RestBindingMode.auto) || bindingMode.equals((Object)RestConfiguration.RestBindingMode.xml) || bindingMode.equals((Object)RestConfiguration.RestBindingMode.json_xml))) {
            isXml = bindingMode.equals((Object)RestConfiguration.RestBindingMode.auto) || bindingMode.equals((Object)RestConfiguration.RestBindingMode.xml) || bindingMode.equals((Object)RestConfiguration.RestBindingMode.json_xml);
            isJson = bindingMode.equals((Object)RestConfiguration.RestBindingMode.auto) || bindingMode.equals((Object)RestConfiguration.RestBindingMode.json) || bindingMode.equals((Object)RestConfiguration.RestBindingMode.json_xml);
        }
        boolean requiredBody = false;
        if (o.getRequestBody() != null) {
            boolean bl = requiredBody = Boolean.TRUE == o.getRequestBody().getRequired();
        }
        if (requiredBody) {
            String body = null;
            if (exchange.getIn().getBody() != null && (isXml || isJson) && (body = MessageHelper.extractBodyAsString((Message)exchange.getIn())) != null) {
                if (exchange.getIn() instanceof DataTypeAware) {
                    ((DataTypeAware)exchange.getIn()).setBody((Object)body, new DataType(isJson ? "json" : "xml"));
                } else {
                    exchange.getIn().setBody((Object)body);
                }
                if (isXml && isJson) {
                    isXml = body.startsWith("<");
                    boolean bl = isJson = !isXml;
                }
            }
            if (body == null && ObjectHelper.isNotEmpty((String)(body = MessageHelper.extractBodyAsString((Message)exchange.getIn())))) {
                exchange.getIn().setBody((Object)body);
            }
            if (ObjectHelper.isEmpty(body)) {
                exchange.getMessage().setHeader("CamelHttpResponseCode", (Object)400);
                exchange.getMessage().setBody((Object)"The request body is missing.");
                exchange.setRouteStop(true);
                callback.done(true);
                return true;
            }
        }
        Map requiredQueryParameters = null;
        if (o.getParameters() != null) {
            requiredQueryParameters = o.getParameters().stream().filter(p -> "query".equals(p.getIn())).filter(p -> Boolean.TRUE == p.getRequired()).collect(Collectors.toMap(Parameter::getName, Function.identity()));
        }
        if (requiredQueryParameters != null && !exchange.getIn().getHeaders().keySet().containsAll(requiredQueryParameters.keySet())) {
            exchange.getMessage().setHeader("CamelHttpResponseCode", (Object)400);
            exchange.getMessage().setBody((Object)"Some of the required query parameters are missing.");
            exchange.setRouteStop(true);
            callback.done(true);
            return true;
        }
        Map requiredHeaders = null;
        if (o.getParameters() != null) {
            requiredHeaders = o.getParameters().stream().filter(p -> "header".equals(p.getIn())).filter(p -> Boolean.TRUE == p.getRequired()).collect(Collectors.toMap(Parameter::getName, Function.identity()));
        }
        if (requiredHeaders != null && !exchange.getIn().getHeaders().keySet().containsAll(requiredHeaders.keySet())) {
            exchange.getMessage().setHeader("CamelHttpResponseCode", (Object)400);
            exchange.getMessage().setBody((Object)"Some of the required HTTP headers are missing.");
            exchange.setRouteStop(true);
            callback.done(true);
            return true;
        }
        Map<String, List> allowedValues = null;
        if (o.getParameters() != null) {
            allowedValues = o.getParameters().stream().filter(p -> "query".equals(p.getIn())).filter(p -> p.getSchema() != null).filter(p -> p.getSchema().getEnum() != null).collect(Collectors.toMap(Parameter::getName, e -> e.getSchema().getEnum()));
        }
        if (allowedValues != null) {
            for (Map.Entry e2 : allowedValues.entrySet()) {
                String k = (String)e2.getKey();
                Object v = exchange.getMessage().getHeader(k);
                if (v == null) continue;
                if (!((List)e2.getValue()).stream().noneMatch(v::equals)) continue;
                exchange.getMessage().setHeader("CamelHttpResponseCode", (Object)400);
                exchange.getMessage().setBody((Object)"Some of the query parameters or HTTP headers has a not-allowed value.");
                exchange.setRouteStop(true);
                callback.done(true);
                return true;
            }
        }
        return false;
    }

    protected void doBuild() throws Exception {
        super.doBuild();
        CamelContextAware.trySetCamelContext((Object)this.restOpenapiProcessorStrategy, (CamelContext)this.getCamelContext());
        for (Map.Entry e : this.openAPI.getPaths().entrySet()) {
            String path = (String)e.getKey();
            for (Map.Entry o : ((PathItem)e.getValue()).readOperationsMap().entrySet()) {
                String v = ((PathItem.HttpMethod)o.getKey()).name();
                RestBindingAdvice binding = this.createRestBinding((Operation)o.getValue());
                ServiceHelper.buildService((Object)binding);
                this.paths.add(new RestOpenApiConsumerPath(v, path, (Operation)o.getValue(), binding));
            }
        }
        this.scannedClasses.clear();
        ServiceHelper.buildService((Object)this.restOpenapiProcessorStrategy);
    }

    private RestBindingAdvice createRestBinding(Operation o) throws Exception {
        Content c;
        Object c2;
        RestConfiguration config = this.camelContext.getRestConfiguration();
        RestConfiguration.RestBindingMode mode = config.getBindingMode();
        RestBindingConfiguration bc = new RestBindingConfiguration();
        bc.setBindingMode(mode.name());
        bc.setEnableCORS(config.isEnableCORS());
        bc.setCorsHeaders(config.getCorsHeaders());
        bc.setClientRequestValidation(config.isClientRequestValidation());
        bc.setEnableNoContentResponse(config.isEnableNoContentResponse());
        bc.setSkipBindingOnErrorCode(config.isSkipBindingOnErrorCode());
        String consumes = this.endpoint.getConsumes();
        String produces = this.endpoint.getProduces();
        if (o.getRequestBody() != null && (c2 = o.getRequestBody().getContent()) != null) {
            consumes = c2.keySet().stream().sorted().collect(Collectors.joining(","));
        }
        if (o.getResponses() != null) {
            for (ApiResponse a : o.getResponses().values()) {
                Content c3 = a.getContent();
                if (c3 == null) continue;
                produces = c3.keySet().stream().sorted().collect(Collectors.joining(","));
            }
        }
        bc.setConsumes(consumes);
        bc.setProduces(produces);
        boolean requiredBody = false;
        if (o.getRequestBody() != null) {
            requiredBody = Boolean.TRUE == o.getRequestBody().getRequired();
        }
        bc.setRequiredBody(requiredBody);
        Set requiredQueryParameters = null;
        if (o.getParameters() != null) {
            requiredQueryParameters = o.getParameters().stream().filter(p -> "query".equals(p.getIn())).filter(p -> Boolean.TRUE == p.getRequired()).map(Parameter::getName).collect(Collectors.toSet());
        }
        if (requiredQueryParameters != null) {
            bc.setRequiredQueryParameters(requiredQueryParameters);
        }
        Set requiredHeaders = null;
        if (o.getParameters() != null) {
            requiredHeaders = o.getParameters().stream().filter(p -> "header".equals(p.getIn())).filter(p -> Boolean.TRUE == p.getRequired()).map(Parameter::getName).collect(Collectors.toSet());
        }
        if (requiredHeaders != null) {
            bc.setRequiredHeaders(requiredHeaders);
        }
        Map<String, String> defaultQueryValues = null;
        if (o.getParameters() != null) {
            defaultQueryValues = o.getParameters().stream().filter(p -> "query".equals(p.getIn())).filter(p -> p.getSchema() != null).filter(p -> p.getSchema().getDefault() != null).collect(Collectors.toMap(Parameter::getName, p -> p.getSchema().getDefault().toString()));
        }
        if (defaultQueryValues != null) {
            bc.setQueryDefaultValues(defaultQueryValues);
        }
        if (o.getRequestBody() != null && (c = o.getRequestBody().getContent()) != null) {
            for (Map.Entry m : c.entrySet()) {
                Class<?> clazz;
                Schema s;
                String mt = (String)m.getKey();
                if (!mt.contains("json") && !mt.contains("xml") || (s = ((MediaType)m.getValue()).getSchema()) == null || s.getXml() == null) continue;
                String ref = s.getXml().getName();
                boolean array = "array".equals(s.getType());
                if (ref == null || (clazz = this.loadBindingClass(this.camelContext, ref)) == null) continue;
                Object name = clazz.getName();
                if (array) {
                    name = (String)name + "[]";
                }
                bc.setType((String)name);
                break;
            }
        }
        if (o.getResponses() != null) {
            block2: for (ApiResponse a : o.getResponses().values()) {
                Content c4 = a.getContent();
                if (c4 == null) continue;
                for (Map.Entry m : c4.entrySet()) {
                    Class<?> clazz;
                    Schema s;
                    String mt = (String)m.getKey();
                    if (!mt.contains("json") && !mt.contains("xml") || (s = ((MediaType)m.getValue()).getSchema()) == null || s.getXml() == null) continue;
                    String ref = s.getXml().getName();
                    boolean array = "array".equals(s.getType());
                    if (ref == null || (clazz = this.loadBindingClass(this.camelContext, ref)) == null) continue;
                    Object name = clazz.getName();
                    if (array) {
                        name = (String)name + "[]";
                    }
                    bc.setOutType((String)name);
                    continue block2;
                }
            }
        }
        return RestBindingAdviceFactory.build((CamelContext)this.camelContext, (RestBindingConfiguration)bc);
    }

    private Class<?> loadBindingClass(CamelContext camelContext, String ref) {
        String base;
        if (ref == null) {
            return null;
        }
        if (this.packageScanInit.compareAndSet(false, true) && (base = this.endpoint.getBindingPackageScan()) != null) {
            StartupStepRecorder recorder = camelContext.getCamelContextExtension().getStartupStepRecorder();
            StartupStep step = recorder.beginStep(RestOpenApiProcessor.class, "openapi-binding", "OpenAPI binding classes package scan");
            String[] pcks = base.split(",");
            PackageScanClassResolver resolver = PluginHelper.getPackageScanClassResolver((CamelContext)camelContext);
            this.scannedClasses.addAll(resolver.findImplementations(Object.class, pcks));
            if (!this.scannedClasses.isEmpty()) {
                LOG.info("Binding package scan found {} classes in packages: {}", (Object)this.scannedClasses.size(), (Object)base);
            }
            recorder.endStep(step);
        }
        ref = Character.toUpperCase(((String)ref).charAt(0)) + ((String)ref).substring(1);
        for (Class<?> clazz : this.scannedClasses) {
            if (!clazz.getSimpleName().equals(ref)) continue;
            return clazz;
        }
        return null;
    }

    protected void doInit() throws Exception {
        super.doInit();
        this.restOpenapiProcessorStrategy.setMissingOperation(this.endpoint.getMissingOperation());
        this.restOpenapiProcessorStrategy.setMockIncludePattern(this.endpoint.getMockIncludePattern());
        ServiceHelper.initService((Object)this.restOpenapiProcessorStrategy);
        this.restOpenapiProcessorStrategy.validateOpenApi(this.openAPI, this.platformHttpConsumer);
    }

    protected void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService((Object)this.restOpenapiProcessorStrategy);
        for (RestConsumerContextPathMatcher.ConsumerPath<Operation> p : this.paths) {
            if (!(p instanceof RestOpenApiConsumerPath)) continue;
            RestOpenApiConsumerPath rcp = (RestOpenApiConsumerPath)p;
            ServiceHelper.startService((Service)rcp.getBinding());
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService((Object)this.restOpenapiProcessorStrategy);
        for (RestConsumerContextPathMatcher.ConsumerPath<Operation> p : this.paths) {
            if (!(p instanceof RestOpenApiConsumerPath)) continue;
            RestOpenApiConsumerPath rcp = (RestOpenApiConsumerPath)p;
            ServiceHelper.stopService((Service)rcp.getBinding());
        }
        this.paths.clear();
    }
}

