/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest.openapi.validator;

import com.fasterxml.jackson.databind.json.JsonMapper;
import io.swagger.v3.oas.models.media.Content;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.rest.openapi.validator.RequestValidator;
import org.apache.camel.component.rest.openapi.validator.RestOpenApiOperation;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.http.RestUtil;
import org.apache.camel.util.ObjectHelper;

public class DefaultRequestValidator
implements RequestValidator {
    private RestOpenApiOperation operation;

    @Override
    public void setOperation(RestOpenApiOperation operation) {
        this.operation = operation;
    }

    @Override
    public RestOpenApiOperation getOperation() {
        return this.operation;
    }

    @Override
    public Set<String> validate(Exchange exchange, RestOpenApiOperation o) {
        Object body;
        Content c;
        LinkedHashSet<Object> validationErrors = new LinkedHashSet<Object>();
        Message message = exchange.getMessage();
        String contentType = (String)message.getHeader("Content-Type", String.class);
        String consumes = null;
        if (o.getOperation().getRequestBody() != null && (c = o.getOperation().getRequestBody().getContent()) != null) {
            consumes = c.keySet().stream().sorted().collect(Collectors.joining(","));
        }
        if (contentType != null && !RestUtil.isValidOrAcceptedContentType(consumes, (String)contentType)) {
            validationErrors.add("Request Content-Type header '" + contentType + "' does not match any allowed types");
        }
        boolean requiredBody = false;
        if (o.getOperation().getRequestBody() != null) {
            boolean bl = requiredBody = Boolean.TRUE == o.getOperation().getRequestBody().getRequired();
        }
        if (requiredBody) {
            body = message.getBody();
            if (body != null) {
                body = MessageHelper.extractBodyAsString((Message)message);
            }
            if (ObjectHelper.isEmpty((Object)body)) {
                validationErrors.add("A request body is required but none found.");
            }
        }
        if (contentType != null && RestUtil.isValidOrAcceptedContentType((String)"application/json", (String)contentType) && (body = message.getBody()) != null) {
            String text = MessageHelper.extractBodyAsString((Message)message);
            JsonMapper om = new JsonMapper();
            try {
                om.readTree(text);
            }
            catch (Exception e) {
                validationErrors.add("Unable to parse JSON");
            }
        }
        o.getQueryParams().stream().filter(parameter -> Objects.nonNull(parameter.getRequired()) && parameter.getRequired() != false).forEach(parameter -> {
            Object header = message.getHeader(parameter.getName());
            if (ObjectHelper.isEmpty((Object)header)) {
                validationErrors.add("Query parameter '" + parameter.getName() + "' is required but none found.");
            }
        });
        o.getHeaders().stream().filter(parameter -> Objects.nonNull(parameter.getRequired()) && parameter.getRequired() != false).forEach(parameter -> {
            Object header = message.getHeader(parameter.getName());
            if (ObjectHelper.isEmpty((Object)header)) {
                validationErrors.add("Header parameter '" + parameter.getName() + "' is required but none found.");
            }
        });
        MessageHelper.resetStreamCache((Message)message);
        return Collections.unmodifiableSet(validationErrors);
    }
}

