/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.snakeyaml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.camel.component.snakeyaml.TypeFilter;
import org.apache.camel.util.StringHelper;

public final class TypeFilters {
    private TypeFilters() {
    }

    public static Optional<TypeFilter> valueOf(String definition) {
        String type = StringHelper.before((String)definition, (String)":");
        if (type == null || "type".equals(type)) {
            return StringHelper.after((String)definition, (String)":", TypeName::new);
        }
        if ("regexp".equals(type)) {
            return StringHelper.after((String)definition, (String)":", RegExp::new);
        }
        return Optional.empty();
    }

    public static TypeFilter regexp(String ... patterns) {
        return new RegExp(Arrays.asList(patterns));
    }

    public static TypeFilter regexp(Collection<String> patterns) {
        return new RegExp(patterns);
    }

    public static TypeFilter typeNames(Collection<String> values) {
        return new TypeName(values);
    }

    public static TypeFilter typeNames(String ... values) {
        return TypeFilters.typeNames(Arrays.asList(values));
    }

    public static TypeFilter types(Collection<Class<?>> values) {
        return new TypeName(values.stream().map(c -> c.getName()).collect(Collectors.toList()));
    }

    public static TypeFilter types(Class<?> ... values) {
        return TypeFilters.types(Arrays.asList(values));
    }

    public static TypeFilter allowAll() {
        return s -> true;
    }

    public static TypeFilter allowNone() {
        return s -> false;
    }

    public static final class TypeName
    implements TypeFilter {
        private final List<String> values;

        public TypeName(String value) {
            this.values = Collections.singletonList(value);
        }

        public TypeName(Collection<String> values) {
            this.values = new ArrayList<String>(values);
        }

        @Override
        public boolean test(String type) {
            return this.values.contains(type);
        }
    }

    public static final class RegExp
    implements TypeFilter {
        private final List<Predicate<String>> predicates;

        public RegExp(String pattern) {
            this.predicates = Collections.singletonList(Pattern.compile(pattern).asPredicate());
        }

        public RegExp(Collection<String> patterns) {
            this.predicates = patterns.stream().map(Pattern::compile).map(Pattern::asPredicate).collect(Collectors.toList());
        }

        @Override
        public boolean test(String type) {
            return this.predicates.stream().anyMatch(p -> p.test(type));
        }
    }
}

