/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.integration.adapter;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.spring.integration.SpringIntegrationBinding;
import org.apache.camel.component.spring.integration.adapter.AbstractCamelAdapter;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultExchange;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.MessageDeliveryException;
import org.springframework.integration.core.MessageHandler;

public class CamelTargetAdapter
extends AbstractCamelAdapter
implements MessageHandler {
    private ProducerTemplate camelTemplate;
    private MessageChannel replyChannel;

    public void setReplyChannel(MessageChannel channel) {
        this.replyChannel = channel;
    }

    public MessageChannel getReplyChannel() {
        return this.replyChannel;
    }

    public ProducerTemplate getCamelTemplate() throws Exception {
        if (this.camelTemplate == null) {
            CamelContext ctx = this.getCamelContext();
            if (ctx == null) {
                ctx = new DefaultCamelContext();
            }
            this.camelTemplate = ctx.createProducerTemplate();
        }
        return this.camelTemplate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean send(Message<?> message) throws Exception {
        boolean result = false;
        ExchangePattern pattern = this.isExpectReply() ? ExchangePattern.InOut : ExchangePattern.InOnly;
        DefaultExchange inExchange = new DefaultExchange(this.getCamelContext(), pattern);
        SpringIntegrationBinding.storeToCamelMessage(message, inExchange.getIn());
        Exchange outExchange = this.getCamelTemplate().send(this.getCamelEndpointUri(), (Exchange)inExchange);
        if (outExchange.getOut() != null && outExchange.getOut().isFault()) {
            result = true;
        }
        if (!this.isExpectReply()) return result;
        Message<?> response = SpringIntegrationBinding.storeToSpringIntegrationMessage(outExchange.getOut());
        if (this.replyChannel != null) return this.replyChannel.send(response);
        MessageChannel messageReplyChannel = (MessageChannel)message.getHeaders().get((Object)"replyChannel");
        if (messageReplyChannel == null) throw new MessageDeliveryException(response, "Cannot resolve ReplyChannel from message: " + message);
        return messageReplyChannel.send(response);
    }

    public void handleMessage(Message<?> message) throws MessageDeliveryException {
        try {
            this.send(message);
        }
        catch (Exception e) {
            throw new MessageDeliveryException(message, "Cannot send message", (Throwable)e);
        }
    }
}

