/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.integration;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.spring.integration.SpringIntegrationBinding;
import org.apache.camel.component.spring.integration.SpringIntegrationEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.integration.channel.BeanFactoryChannelResolver;
import org.springframework.integration.channel.ChannelResolver;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.core.Message;
import org.springframework.integration.core.MessageChannel;
import org.springframework.integration.message.MessageHandler;

public class SpringIntegrationProducer
extends DefaultProducer
implements Processor {
    private static final transient Log LOG = LogFactory.getLog(SpringIntegrationProducer.class);
    private SpringCamelContext context;
    private DirectChannel inputChannel;
    private MessageChannel outputChannel;
    private String outputChannelName;
    private ChannelResolver channelResolver;
    private SpringIntegrationEndpoint endpoint;

    public SpringIntegrationProducer(SpringIntegrationEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.context = (SpringCamelContext)endpoint.getCamelContext();
        if (this.context != null && endpoint.getMessageChannel() == null) {
            this.outputChannelName = endpoint.getDefaultChannel();
            this.channelResolver = new BeanFactoryChannelResolver((BeanFactory)this.context.getApplicationContext());
            if (ObjectHelper.isEmpty((Object)this.outputChannelName)) {
                this.outputChannelName = endpoint.getInputChannel();
            }
            if (ObjectHelper.isEmpty((Object)this.outputChannelName)) {
                throw new RuntimeCamelException("Cannot find outputChannelName, please check the endpoint uri outputChannel part!");
            }
            this.outputChannel = this.channelResolver.resolveChannelName(this.outputChannelName);
        } else if (endpoint.getMessageChannel() != null) {
            this.outputChannel = endpoint.getMessageChannel();
        } else {
            throw new RuntimeCamelException("Cannot find message channel, please check your configuration.");
        }
        if (endpoint.isInOut()) {
            endpoint.setExchangePattern(ExchangePattern.InOut);
            if (ObjectHelper.isEmpty((Object)endpoint.getInputChannel())) {
                throw new RuntimeCamelException("Cannot find inputChannel, please check the endpoint uri inputChannel part!");
            }
            this.inputChannel = (DirectChannel)this.channelResolver.resolveChannelName(endpoint.getInputChannel());
        } else {
            endpoint.setExchangePattern(ExchangePattern.InOnly);
        }
    }

    public void process(final Exchange exchange) throws Exception {
        if (exchange.getPattern().isOutCapable()) {
            exchange.getIn().getHeaders().put("springintegration_replyChannel", this.inputChannel);
            this.inputChannel.subscribe(new MessageHandler(){

                public void handleMessage(Message<?> message) {
                    SpringIntegrationBinding.storeToCamelMessage(message, exchange.getOut());
                }
            });
        }
        Message siOutmessage = SpringIntegrationBinding.createSpringIntegrationMessage(exchange);
        this.outputChannel.send(siOutmessage);
    }
}

