/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.integration.adapter;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.spring.integration.SpringIntegrationBinding;
import org.apache.camel.component.spring.integration.adapter.AbstractCamelAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.core.Message;
import org.springframework.integration.core.MessageChannel;
import org.springframework.integration.message.MessageHandler;

public class CamelSourceAdapter
extends AbstractCamelAdapter
implements InitializingBean,
DisposableBean {
    private static final Log LOG = LogFactory.getLog(CamelSourceAdapter.class);
    private Consumer consumer;
    private Endpoint camelEndpoint;
    private MessageChannel requestChannel;
    private DirectChannel replyChannel;
    private AtomicBoolean initialized = new AtomicBoolean();

    public void setRequestChannel(MessageChannel channel) {
        this.requestChannel = channel;
    }

    public MessageChannel getChannel() {
        return this.requestChannel;
    }

    public void setReplyChannel(DirectChannel channel) {
        this.replyChannel = channel;
    }

    public final void afterPropertiesSet() throws Exception {
        if (this.initialized.compareAndSet(false, true)) {
            this.initialize();
        }
    }

    public void destroy() throws Exception {
        if (this.consumer != null) {
            this.consumer.stop();
        }
    }

    protected void initialize() throws Exception {
        this.camelEndpoint = this.getCamelContext().getEndpoint(this.getCamelEndpointUri());
        this.consumer = this.camelEndpoint.createConsumer((Processor)new ConsumerProcessor());
        this.consumer.start();
    }

    protected class ConsumerProcessor
    implements Processor {
        protected ConsumerProcessor() {
        }

        public void process(final Exchange exchange) throws Exception {
            Message request = SpringIntegrationBinding.createSpringIntegrationMessage(exchange);
            if (exchange.getPattern().isOutCapable()) {
                exchange.getIn().getHeaders().put("springintegration_replyChannel", CamelSourceAdapter.this.replyChannel);
                CamelSourceAdapter.this.replyChannel.subscribe(new MessageHandler(){

                    public void handleMessage(Message<?> message) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"set the out message with the SI response message");
                        }
                        SpringIntegrationBinding.storeToCamelMessage(message, exchange.getOut());
                    }
                });
            }
            CamelSourceAdapter.this.requestChannel.send(request);
        }
    }
}

