/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.integration.converter;

import java.util.Map;
import org.apache.camel.Converter;
import org.apache.camel.Endpoint;
import org.apache.camel.Message;
import org.apache.camel.component.spring.integration.SpringIntegrationEndpoint;
import org.apache.camel.component.spring.integration.SpringIntegrationMessage;
import org.springframework.integration.core.MessageChannel;
import org.springframework.integration.core.MessageHeaders;
import org.springframework.integration.message.GenericMessage;

@Converter
public final class SpringIntegrationConverter {
    private SpringIntegrationConverter() {
    }

    @Converter
    public static Endpoint toEndpoint(MessageChannel channel) throws Exception {
        if (channel == null) {
            throw new IllegalArgumentException("The MessageChannel is null");
        }
        SpringIntegrationEndpoint answer = new SpringIntegrationEndpoint("URL", channel, null);
        return answer;
    }

    @Converter
    public static org.springframework.integration.core.Message toSpringMessage(Message camelMessage) throws Exception {
        SpringIntegrationMessage siMessage;
        org.springframework.integration.core.Message message;
        if (camelMessage instanceof SpringIntegrationMessage && (message = (siMessage = (SpringIntegrationMessage)camelMessage).getMessage()) != null) {
            return message;
        }
        MessageHeaders messageHeaders = new MessageHeaders(camelMessage.getHeaders());
        return new GenericMessage(camelMessage.getBody(), (Map)messageHeaders);
    }

    @Converter
    public static Message toCamelMessage(org.springframework.integration.core.Message springMessage) throws Exception {
        return new SpringIntegrationMessage(springMessage);
    }
}

