/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import org.apache.camel.CamelContext;

public class ClassLoadingAwareObjectInputStream
extends ObjectInputStream {
    private static final HashMap<String, Class<?>> PRIM_CLASSES = new HashMap(8, 1.0f);
    private CamelContext camelContext;

    public ClassLoadingAwareObjectInputStream(CamelContext camelContext, InputStream in) throws IOException {
        super(in);
        this.camelContext = camelContext;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return this.camelContext.getClassResolver().resolveClass(classDesc.getName(), cl);
    }

    @Override
    protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class[] cinterfaces = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            cinterfaces[i] = this.camelContext.getClassResolver().resolveClass(interfaces[i], cl);
        }
        try {
            return Proxy.getProxyClass(cinterfaces[0].getClassLoader(), cinterfaces);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }

    static {
        PRIM_CLASSES.put("boolean", Boolean.TYPE);
        PRIM_CLASSES.put("byte", Byte.TYPE);
        PRIM_CLASSES.put("char", Character.TYPE);
        PRIM_CLASSES.put("short", Short.TYPE);
        PRIM_CLASSES.put("int", Integer.TYPE);
        PRIM_CLASSES.put("long", Long.TYPE);
        PRIM_CLASSES.put("float", Float.TYPE);
        PRIM_CLASSES.put("double", Double.TYPE);
        PRIM_CLASSES.put("void", Void.TYPE);
    }
}

