/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.Closeable;
import java.io.InputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.IsSingleton;
import org.apache.camel.spi.Language;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.IOHelper;

public abstract class LanguageSupport
implements Language,
IsSingleton,
CamelContextAware {
    public static final String RESOURCE = "resource:";
    private CamelContext camelContext;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public boolean isSingleton() {
        return true;
    }

    protected String loadResource(String expression) throws ExpressionIllegalSyntaxException {
        if (this.camelContext != null && expression.startsWith(RESOURCE)) {
            String uri = expression.substring(RESOURCE.length());
            InputStream is = null;
            try {
                is = ResourceHelper.resolveMandatoryResourceAsInputStream(this.camelContext, uri);
                expression = (String)this.camelContext.getTypeConverter().mandatoryConvertTo(String.class, (Object)is);
            }
            catch (Exception e) {
                try {
                    throw new ExpressionIllegalSyntaxException(expression, (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOHelper.close(is);
                    throw throwable;
                }
            }
            IOHelper.close((Closeable)is);
        }
        return expression;
    }
}

