/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.NormalizedEndpointUri;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RouteStartupOrder;
import org.apache.camel.util.ObjectHelper;

public final class CamelContextHelper {
    public static final String MODEL_DOCUMENTATION_PREFIX = "org/apache/camel/model/";

    private CamelContextHelper() {
    }

    public static Endpoint getMandatoryEndpoint(CamelContext camelContext, String uri) throws NoSuchEndpointException {
        Endpoint endpoint = camelContext.getEndpoint(uri);
        if (endpoint == null) {
            throw new NoSuchEndpointException(uri);
        }
        return endpoint;
    }

    public static Endpoint getMandatoryEndpoint(CamelContext camelContext, NormalizedEndpointUri uri) throws NoSuchEndpointException {
        ExtendedCamelContext ecc = (ExtendedCamelContext)camelContext;
        Endpoint endpoint = ecc.getEndpoint(uri);
        if (endpoint == null) {
            throw new NoSuchEndpointException(uri.getUri());
        }
        return endpoint;
    }

    public static Endpoint getMandatoryPrototypeEndpoint(CamelContext camelContext, String uri) throws NoSuchEndpointException {
        ExtendedCamelContext ecc = (ExtendedCamelContext)camelContext;
        Endpoint endpoint = ecc.getPrototypeEndpoint(uri);
        if (endpoint == null) {
            throw new NoSuchEndpointException(uri);
        }
        return endpoint;
    }

    public static Endpoint getMandatoryPrototypeEndpoint(CamelContext camelContext, NormalizedEndpointUri uri) throws NoSuchEndpointException {
        ExtendedCamelContext ecc = (ExtendedCamelContext)camelContext;
        Endpoint endpoint = ecc.getPrototypeEndpoint(uri);
        if (endpoint == null) {
            throw new NoSuchEndpointException(uri.getUri());
        }
        return endpoint;
    }

    public static <T extends Endpoint> T getMandatoryEndpoint(CamelContext camelContext, String uri, Class<T> type) {
        Endpoint endpoint = CamelContextHelper.getMandatoryEndpoint(camelContext, uri);
        return (T)((Endpoint)ObjectHelper.cast(type, (Object)endpoint));
    }

    public static Endpoint resolveEndpoint(CamelContext camelContext, String uri, String ref) {
        Endpoint endpoint = null;
        if (uri != null && (endpoint = camelContext.getEndpoint(uri)) == null) {
            throw new NoSuchEndpointException(uri);
        }
        if (ref != null) {
            endpoint = (Endpoint)camelContext.getRegistry().lookupByNameAndType(ref, Endpoint.class);
            if (endpoint == null) {
                throw new NoSuchEndpointException("ref:" + ref, "check your camel registry with id " + ref);
            }
            if (!camelContext.equals(endpoint.getCamelContext())) {
                throw new NoSuchEndpointException("ref:" + ref, "make sure the endpoint has the same camel context as the route does.");
            }
            try {
                camelContext.addService((Object)endpoint);
            }
            catch (Exception ex) {
                throw new RuntimeCamelException((Throwable)ex);
            }
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("Either 'uri' or 'ref' must be specified");
        }
        return endpoint;
    }

    public static <T> T convertTo(CamelContext context, Class<T> type, Object value) {
        return (T)context.getTypeConverter().convertTo(type, value);
    }

    public static <T> T tryConvertTo(CamelContext context, Class<T> type, Object value) {
        return (T)context.getTypeConverter().tryConvertTo(type, value);
    }

    public static <T> T mandatoryConvertTo(CamelContext context, Class<T> type, Object value) {
        T answer = CamelContextHelper.convertTo(context, type, value);
        if (answer == null) {
            throw new IllegalArgumentException("Value " + value + " converted to " + type.getName() + " cannot be null");
        }
        return answer;
    }

    public static <T> T newInstance(CamelContext context, Class<T> beanType) {
        return (T)context.getInjector().newInstance(beanType);
    }

    public static Object lookup(CamelContext context, String name) {
        return context.getRegistry().lookupByName(name);
    }

    public static <T> T lookup(CamelContext context, String name, Class<T> beanType) {
        return (T)context.getRegistry().lookupByNameAndType(name, beanType);
    }

    public static <T> T lookupAndConvert(CamelContext context, String name, Class<T> beanType) {
        return CamelContextHelper.tryConvertTo(context, beanType, CamelContextHelper.lookup(context, name));
    }

    public static <T> T findSingleByType(CamelContext camelContext, Class<T> type) {
        return (T)camelContext.getRegistry().findSingleByType(type);
    }

    public static Object mandatoryLookup(CamelContext context, String name) {
        Object answer = CamelContextHelper.lookup(context, name);
        if (answer == null) {
            throw new NoSuchBeanException(name);
        }
        return answer;
    }

    public static <T> T mandatoryLookup(CamelContext context, String name, Class<T> beanType) {
        T answer = CamelContextHelper.lookup(context, name, beanType);
        if (answer == null) {
            throw new NoSuchBeanException(name, beanType.getName());
        }
        return answer;
    }

    public static <T> T mandatoryLookupAndConvert(CamelContext context, String name, Class<T> beanType) {
        Object value = CamelContextHelper.lookup(context, name);
        if (value == null) {
            throw new NoSuchBeanException(name, beanType.getName());
        }
        return CamelContextHelper.convertTo(context, beanType, value);
    }

    public static Endpoint getEndpointInjection(CamelContext camelContext, String uri, String injectionPointName, boolean mandatory) {
        Endpoint endpoint = ObjectHelper.isNotEmpty((String)uri) ? camelContext.getEndpoint(uri) : (mandatory ? CamelContextHelper.mandatoryLookup(camelContext, injectionPointName, Endpoint.class) : CamelContextHelper.lookup(camelContext, injectionPointName, Endpoint.class));
        return endpoint;
    }

    public static int getMaximumCachePoolSize(CamelContext camelContext) throws IllegalArgumentException {
        String s;
        if (camelContext != null && (s = camelContext.getGlobalOption("CamelMaximumCachePoolSize")) != null) {
            try {
                Integer size = Integer.valueOf(s);
                if (size == null || size <= 0) {
                    throw new IllegalArgumentException("Property CamelMaximumCachePoolSize must be a positive number, was: " + s);
                }
                return size;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Property CamelMaximumCachePoolSize must be a positive number, was: " + s, e);
            }
        }
        return 1000;
    }

    public static int getMaximumEndpointCacheSize(CamelContext camelContext) throws IllegalArgumentException {
        String s;
        if (camelContext != null && (s = camelContext.getGlobalOption("CamelMaximumEndpointCacheSize")) != null) {
            try {
                int size = Integer.parseInt(s);
                if (size <= 0) {
                    throw new IllegalArgumentException("Property CamelMaximumEndpointCacheSize must be a positive number, was: " + s);
                }
                return size;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Property CamelMaximumEndpointCacheSize must be a positive number, was: " + s, e);
            }
        }
        return 1000;
    }

    public static int getMaximumSimpleCacheSize(CamelContext camelContext) throws IllegalArgumentException {
        String s;
        if (camelContext != null && (s = camelContext.getGlobalOption("CamelMaximumSimpleCacheSize")) != null) {
            try {
                Integer size = Integer.valueOf(s);
                if (size == null || size <= 0) {
                    throw new IllegalArgumentException("Property CamelMaximumSimpleCacheSize must be a positive number, was: " + s);
                }
                return size;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Property CamelMaximumSimpleCacheSize must be a positive number, was: " + s, e);
            }
        }
        return 1000;
    }

    public static int getMaximumTransformerCacheSize(CamelContext camelContext) throws IllegalArgumentException {
        String s;
        if (camelContext != null && (s = camelContext.getGlobalOption("CamelMaximumTransformerCacheSize")) != null) {
            try {
                Integer size = Integer.valueOf(s);
                if (size == null || size <= 0) {
                    throw new IllegalArgumentException("Property CamelMaximumTransformerCacheSize must be a positive number, was: " + s);
                }
                return size;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Property CamelMaximumTransformerCacheSize must be a positive number, was: " + s, e);
            }
        }
        return 1000;
    }

    public static int getMaximumValidatorCacheSize(CamelContext camelContext) throws IllegalArgumentException {
        String s;
        if (camelContext != null && (s = camelContext.getGlobalOption("CamelMaximumValidatorCacheSize")) != null) {
            try {
                Integer size = Integer.valueOf(s);
                if (size == null || size <= 0) {
                    throw new IllegalArgumentException("Property CamelMaximumValidatorCacheSize must be a positive number, was: " + s);
                }
                return size;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Property CamelMaximumValidatorCacheSize must be a positive number, was: " + s, e);
            }
        }
        return 1000;
    }

    public static String parseText(CamelContext camelContext, String text) {
        return camelContext.resolvePropertyPlaceholders(text);
    }

    public static Integer parseInteger(CamelContext camelContext, String text) {
        return CamelContextHelper.parse(camelContext, Integer.class, text);
    }

    public static Integer parseInt(CamelContext camelContext, String text) {
        return CamelContextHelper.parse(camelContext, Integer.class, text);
    }

    public static Long parseLong(CamelContext camelContext, String text) {
        return CamelContextHelper.parse(camelContext, Long.class, text);
    }

    public static Duration parseDuration(CamelContext camelContext, String text) {
        return CamelContextHelper.parse(camelContext, Duration.class, text);
    }

    public static Float parseFloat(CamelContext camelContext, String text) {
        return CamelContextHelper.parse(camelContext, Float.class, text);
    }

    public static Double parseDouble(CamelContext camelContext, String text) {
        return CamelContextHelper.parse(camelContext, Double.class, text);
    }

    public static Boolean parseBoolean(CamelContext camelContext, String text) {
        return CamelContextHelper.parse(camelContext, Boolean.class, text);
    }

    public static <T> T parse(CamelContext camelContext, Class<T> clazz, String text) {
        String s = camelContext.resolvePropertyPlaceholders(text);
        if (s != null) {
            try {
                return (T)camelContext.getTypeConverter().mandatoryConvertTo(clazz, (Object)s);
            }
            catch (Exception e) {
                if (s.equals(text)) {
                    throw new IllegalArgumentException("Error parsing [" + s + "] as a " + clazz.getName() + ".", e);
                }
                throw new IllegalArgumentException("Error parsing [" + s + "] from property " + text + " as a " + clazz.getName() + ".", e);
            }
        }
        return null;
    }

    public static int getRouteStartupOrder(CamelContext camelContext, String routeId) {
        for (RouteStartupOrder order : ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getRouteStartupOrder()) {
            if (!order.getRoute().getId().equals(routeId)) continue;
            return order.getStartupOrder();
        }
        return 0;
    }

    public static Properties getCamelPropertiesWithPrefix(String prefix, CamelContext camelContext) {
        Properties answer = new Properties();
        Map camelProperties = camelContext.getGlobalOptions();
        if (camelProperties != null) {
            for (Map.Entry entry : camelProperties.entrySet()) {
                String key = (String)entry.getKey();
                if (key == null || !key.startsWith(prefix)) continue;
                answer.put(key.substring(prefix.length()), entry.getValue());
            }
        }
        return answer;
    }

    public static String getRouteId(NamedNode node) {
        NamedNode parent;
        for (parent = node; parent != null && parent.getParent() != null; parent = parent.getParent()) {
        }
        return parent != null ? parent.getId() : null;
    }

    public static RestConfiguration getRestConfiguration(CamelContext camelContext, String component) {
        RestConfiguration configuration = camelContext.getRestConfiguration();
        CamelContextHelper.validateRestConfigurationComponent(component, configuration.getComponent());
        return configuration;
    }

    public static RestConfiguration getRestConfiguration(CamelContext camelContext, String component, String producerComponent) {
        RestConfiguration configuration = camelContext.getRestConfiguration();
        CamelContextHelper.validateRestConfigurationComponent(component, configuration.getComponent());
        CamelContextHelper.validateRestConfigurationComponent(producerComponent, configuration.getProducerComponent());
        return configuration;
    }

    private static void validateRestConfigurationComponent(String component, String configurationComponent) {
        if (ObjectHelper.isEmpty((String)component) || ObjectHelper.isEmpty((String)configurationComponent)) {
            return;
        }
        if (!Objects.equals(component, configurationComponent)) {
            throw new IllegalArgumentException("No RestConfiguration for component: " + component + " found, RestConfiguration targets: " + configurationComponent);
        }
    }
}

