/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tooling.model;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.tooling.model.BaseModel;
import org.apache.camel.tooling.model.BaseOptionModel;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.model.DataFormatModel;
import org.apache.camel.tooling.model.EipModel;
import org.apache.camel.tooling.model.LanguageModel;
import org.apache.camel.tooling.model.MainModel;
import org.apache.camel.tooling.model.OtherModel;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;

public final class JsonMapper {
    private JsonMapper() {
    }

    public static BaseModel<?> generateModel(Path file) {
        try {
            String json = new String(Files.readAllBytes(file), StandardCharsets.UTF_8);
            return JsonMapper.generateModel(json);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading json file: " + file, e);
        }
    }

    public static BaseModel<?> generateModel(String json) {
        JsonObject obj = JsonMapper.deserialize(json);
        return JsonMapper.generateModel(obj);
    }

    public static BaseModel<?> generateModel(JsonObject obj) {
        if (obj.containsKey((Object)"component")) {
            return JsonMapper.generateComponentModel(obj);
        }
        if (obj.containsKey((Object)"language")) {
            return JsonMapper.generateLanguageModel(obj);
        }
        if (obj.containsKey((Object)"dataformat")) {
            return JsonMapper.generateDataFormatModel(obj);
        }
        if (obj.containsKey((Object)"other")) {
            return JsonMapper.generateOtherModel(obj);
        }
        if (obj.containsKey((Object)"model")) {
            return JsonMapper.generateEipModel(obj);
        }
        throw new IllegalArgumentException("Unsupported JSON");
    }

    public static ComponentModel generateComponentModel(String json) {
        JsonObject obj = JsonMapper.deserialize(json);
        return JsonMapper.generateComponentModel(obj);
    }

    public static ComponentModel generateComponentModel(JsonObject obj) {
        JsonObject mprp;
        JsonObject mobj = (JsonObject)obj.get((Object)"component");
        ComponentModel model = new ComponentModel();
        JsonMapper.parseComponentModel(mobj, model);
        JsonObject mcprp = (JsonObject)obj.get((Object)"componentProperties");
        if (mcprp != null) {
            for (Map.Entry entry : mcprp.entrySet()) {
                JsonObject mp = (JsonObject)entry.getValue();
                ComponentModel.ComponentOptionModel option = new ComponentModel.ComponentOptionModel();
                JsonMapper.parseOption(mp, option, (String)entry.getKey());
                model.addComponentOption(option);
            }
        }
        if ((mprp = (JsonObject)obj.get((Object)"properties")) != null) {
            for (Map.Entry entry : mprp.entrySet()) {
                JsonObject mp = (JsonObject)entry.getValue();
                ComponentModel.EndpointOptionModel option = new ComponentModel.EndpointOptionModel();
                JsonMapper.parseOption(mp, option, (String)entry.getKey());
                model.addEndpointOption(option);
            }
        }
        return model;
    }

    public static void parseComponentModel(JsonObject mobj, ComponentModel model) {
        JsonMapper.parseModel(mobj, model);
        model.setScheme(mobj.getString("scheme"));
        model.setExtendsScheme(mobj.getString("extendsScheme"));
        model.setAlternativeSchemes(mobj.getString("alternativeSchemes"));
        model.setSyntax(mobj.getString("syntax"));
        model.setAlternativeSyntax(mobj.getString("alternativeSyntax"));
        model.setAsync(mobj.getBooleanOrDefault("async", false));
        model.setConsumerOnly(mobj.getBooleanOrDefault("consumerOnly", false));
        model.setProducerOnly(mobj.getBooleanOrDefault("producerOnly", false));
        model.setLenientProperties(mobj.getBooleanOrDefault("lenientProperties", false));
        model.setGroupId(mobj.getString("groupId"));
        model.setArtifactId(mobj.getString("artifactId"));
        model.setVersion(mobj.getString("version"));
    }

    public static String createParameterJsonSchema(ComponentModel model) {
        JsonObject wrapper = JsonMapper.asJsonObject(model);
        return JsonMapper.serialize(wrapper);
    }

    public static JsonObject asJsonObject(ComponentModel model) {
        JsonObject obj = new JsonObject();
        obj.put((Object)"kind", (Object)model.getKind());
        obj.put((Object)"name", (Object)model.getName());
        obj.put((Object)"scheme", (Object)model.getScheme());
        obj.put((Object)"extendsScheme", (Object)model.getExtendsScheme());
        obj.put((Object)"alternativeSchemes", (Object)model.getAlternativeSchemes());
        obj.put((Object)"syntax", (Object)model.getSyntax());
        obj.put((Object)"alternativeSyntax", (Object)model.getAlternativeSyntax());
        obj.put((Object)"title", (Object)model.getTitle());
        obj.put((Object)"description", (Object)model.getDescription());
        obj.put((Object)"label", (Object)model.getLabel());
        obj.put((Object)"deprecated", (Object)model.isDeprecated());
        obj.put((Object)"deprecationNote", (Object)model.getDeprecationNote());
        obj.put((Object)"async", (Object)model.isAsync());
        obj.put((Object)"consumerOnly", (Object)model.isConsumerOnly());
        obj.put((Object)"producerOnly", (Object)model.isProducerOnly());
        obj.put((Object)"lenientProperties", (Object)model.isLenientProperties());
        obj.put((Object)"javaType", (Object)model.getJavaType());
        obj.put((Object)"firstVersion", (Object)model.getFirstVersion());
        obj.put((Object)"verifiers", (Object)model.getVerifiers());
        obj.put((Object)"groupId", (Object)model.getGroupId());
        obj.put((Object)"artifactId", (Object)model.getArtifactId());
        obj.put((Object)"version", (Object)model.getVersion());
        obj.entrySet().removeIf(e -> e.getValue() == null);
        JsonObject wrapper = new JsonObject();
        wrapper.put((Object)"component", (Object)obj);
        wrapper.put((Object)"componentProperties", (Object)JsonMapper.asJsonObject(model.getComponentOptions()));
        wrapper.put((Object)"properties", (Object)JsonMapper.asJsonObject(model.getEndpointOptions()));
        return wrapper;
    }

    public static DataFormatModel generateDataFormatModel(String json) {
        JsonObject obj = JsonMapper.deserialize(json);
        return JsonMapper.generateDataFormatModel(obj);
    }

    public static DataFormatModel generateDataFormatModel(JsonObject obj) {
        JsonObject mobj = (JsonObject)obj.get((Object)"dataformat");
        DataFormatModel model = new DataFormatModel();
        JsonMapper.parseModel(mobj, model);
        model.setModelName(mobj.getString("modelName"));
        model.setModelJavaType(mobj.getString("modelJavaType"));
        model.setGroupId(mobj.getString("groupId"));
        model.setArtifactId(mobj.getString("artifactId"));
        model.setVersion(mobj.getString("version"));
        JsonObject mprp = (JsonObject)obj.get((Object)"properties");
        for (Map.Entry entry : mprp.entrySet()) {
            JsonObject mp = (JsonObject)entry.getValue();
            DataFormatModel.DataFormatOptionModel option = new DataFormatModel.DataFormatOptionModel();
            JsonMapper.parseOption(mp, option, (String)entry.getKey());
            model.addOption(option);
        }
        return model;
    }

    public static String createParameterJsonSchema(DataFormatModel model) {
        JsonObject wrapper = JsonMapper.asJsonObject(model);
        return JsonMapper.serialize(wrapper);
    }

    public static JsonObject asJsonObject(DataFormatModel model) {
        JsonObject obj = new JsonObject();
        obj.put((Object)"kind", (Object)model.getKind());
        obj.put((Object)"name", (Object)model.getName());
        obj.put((Object)"modelName", (Object)model.getModelName());
        obj.put((Object)"title", (Object)model.getTitle());
        obj.put((Object)"description", (Object)model.getDescription());
        obj.put((Object)"deprecated", (Object)model.isDeprecated());
        obj.put((Object)"deprecationNote", (Object)model.getDeprecationNote());
        obj.put((Object)"firstVersion", (Object)model.getFirstVersion());
        obj.put((Object)"label", (Object)model.getLabel());
        obj.put((Object)"javaType", (Object)model.getJavaType());
        obj.put((Object)"modelJavaType", (Object)model.getModelJavaType());
        obj.put((Object)"groupId", (Object)model.getGroupId());
        obj.put((Object)"artifactId", (Object)model.getArtifactId());
        obj.put((Object)"version", (Object)model.getVersion());
        obj.entrySet().removeIf(e -> e.getValue() == null);
        JsonObject wrapper = new JsonObject();
        wrapper.put((Object)"dataformat", (Object)obj);
        wrapper.put((Object)"properties", (Object)JsonMapper.asJsonObject(model.getOptions()));
        return wrapper;
    }

    public static EipModel generateEipModel(String json) {
        JsonObject obj = JsonMapper.deserialize(json);
        return JsonMapper.generateEipModel(obj);
    }

    public static EipModel generateEipModel(JsonObject obj) {
        JsonObject mobj = (JsonObject)obj.get((Object)"model");
        EipModel model = new EipModel();
        JsonMapper.parseModel(mobj, model);
        model.setInput(mobj.getBooleanOrDefault("input", false));
        model.setOutput(mobj.getBooleanOrDefault("output", false));
        JsonObject mprp = (JsonObject)obj.get((Object)"properties");
        for (Map.Entry entry : mprp.entrySet()) {
            JsonObject mp = (JsonObject)entry.getValue();
            EipModel.EipOptionModel option = new EipModel.EipOptionModel();
            JsonMapper.parseOption(mp, option, (String)entry.getKey());
            model.addOption(option);
        }
        return model;
    }

    public static String createParameterJsonSchema(EipModel model) {
        JsonObject wrapper = JsonMapper.asJsonObject(model);
        return JsonMapper.serialize(wrapper);
    }

    public static JsonObject asJsonObject(EipModel model) {
        JsonObject obj = new JsonObject();
        obj.put((Object)"kind", (Object)model.getKind());
        obj.put((Object)"name", (Object)model.getName());
        obj.put((Object)"title", (Object)model.getTitle());
        obj.put((Object)"description", (Object)model.getDescription());
        obj.put((Object)"firstVersion", (Object)model.getFirstVersion());
        obj.put((Object)"javaType", (Object)model.getJavaType());
        obj.put((Object)"label", (Object)model.getLabel());
        obj.put((Object)"deprecated", (Object)model.isDeprecated());
        obj.put((Object)"deprecationNote", (Object)model.getDeprecationNote());
        obj.put((Object)"input", (Object)model.isInput());
        obj.put((Object)"output", (Object)model.isOutput());
        obj.entrySet().removeIf(e -> e.getValue() == null);
        JsonObject wrapper = new JsonObject();
        wrapper.put((Object)"model", (Object)obj);
        wrapper.put((Object)"properties", (Object)JsonMapper.asJsonObject(model.getOptions()));
        return wrapper;
    }

    public static LanguageModel generateLanguageModel(String json) {
        JsonObject obj = JsonMapper.deserialize(json);
        return JsonMapper.generateLanguageModel(obj);
    }

    public static LanguageModel generateLanguageModel(JsonObject obj) {
        JsonObject mobj = (JsonObject)obj.get((Object)"language");
        LanguageModel model = new LanguageModel();
        JsonMapper.parseModel(mobj, model);
        model.setModelName(mobj.getString("modelName"));
        model.setModelJavaType(mobj.getString("modelJavaType"));
        model.setGroupId(mobj.getString("groupId"));
        model.setArtifactId(mobj.getString("artifactId"));
        model.setVersion(mobj.getString("version"));
        JsonObject mprp = (JsonObject)obj.get((Object)"properties");
        for (Map.Entry entry : mprp.entrySet()) {
            JsonObject mp = (JsonObject)entry.getValue();
            LanguageModel.LanguageOptionModel option = new LanguageModel.LanguageOptionModel();
            JsonMapper.parseOption(mp, option, (String)entry.getKey());
            model.addOption(option);
        }
        return model;
    }

    public static String createParameterJsonSchema(LanguageModel model) {
        JsonObject wrapper = JsonMapper.asJsonObject(model);
        return JsonMapper.serialize(wrapper);
    }

    public static JsonObject asJsonObject(LanguageModel model) {
        JsonObject obj = new JsonObject();
        obj.put((Object)"kind", (Object)model.getKind());
        obj.put((Object)"name", (Object)model.getName());
        obj.put((Object)"modelName", (Object)model.getModelName());
        obj.put((Object)"title", (Object)model.getTitle());
        obj.put((Object)"description", (Object)model.getDescription());
        obj.put((Object)"deprecated", (Object)model.isDeprecated());
        obj.put((Object)"deprecationNote", (Object)model.getDeprecationNote());
        obj.put((Object)"firstVersion", (Object)model.getFirstVersion());
        obj.put((Object)"label", (Object)model.getLabel());
        obj.put((Object)"javaType", (Object)model.getJavaType());
        obj.put((Object)"modelJavaType", (Object)model.getModelJavaType());
        obj.put((Object)"groupId", (Object)model.getGroupId());
        obj.put((Object)"artifactId", (Object)model.getArtifactId());
        obj.put((Object)"version", (Object)model.getVersion());
        obj.entrySet().removeIf(e -> e.getValue() == null);
        JsonObject wrapper = new JsonObject();
        wrapper.put((Object)"language", (Object)obj);
        wrapper.put((Object)"properties", (Object)JsonMapper.asJsonObject(model.getOptions()));
        return wrapper;
    }

    public static OtherModel generateOtherModel(String json) {
        JsonObject obj = JsonMapper.deserialize(json);
        return JsonMapper.generateOtherModel(obj);
    }

    public static OtherModel generateOtherModel(JsonObject obj) {
        JsonObject mobj = (JsonObject)obj.get((Object)"other");
        OtherModel model = new OtherModel();
        JsonMapper.parseModel(mobj, model);
        model.setGroupId(mobj.getString("groupId"));
        model.setArtifactId(mobj.getString("artifactId"));
        model.setVersion(mobj.getString("version"));
        return model;
    }

    public static String createJsonSchema(OtherModel model) {
        JsonObject wrapper = JsonMapper.asJsonObject(model);
        return JsonMapper.serialize(wrapper);
    }

    public static JsonObject asJsonObject(OtherModel model) {
        JsonObject obj = new JsonObject();
        obj.put((Object)"kind", (Object)model.getKind());
        obj.put((Object)"name", (Object)model.getName());
        obj.put((Object)"title", (Object)model.getTitle());
        obj.put((Object)"description", (Object)model.getDescription());
        obj.put((Object)"deprecated", (Object)model.isDeprecated());
        obj.put((Object)"deprecationNote", (Object)model.getDeprecationNote());
        obj.put((Object)"firstVersion", (Object)model.getFirstVersion());
        obj.put((Object)"label", (Object)model.getLabel());
        obj.put((Object)"groupId", (Object)model.getGroupId());
        obj.put((Object)"artifactId", (Object)model.getArtifactId());
        obj.put((Object)"version", (Object)model.getVersion());
        obj.entrySet().removeIf(e -> e.getValue() == null);
        JsonObject wrapper = new JsonObject();
        wrapper.put((Object)"other", (Object)obj);
        return wrapper;
    }

    private static void parseModel(JsonObject mobj, BaseModel<?> model) {
        model.setTitle(mobj.getString("title"));
        model.setName(mobj.getString("name"));
        model.setDescription(mobj.getString("description"));
        model.setFirstVersion(mobj.getString("firstVersion"));
        model.setLabel(mobj.getString("label"));
        model.setDeprecated(mobj.getBooleanOrDefault("deprecated", false));
        model.setDeprecationNote(mobj.getString("label"));
        model.setJavaType(mobj.getString("javaType"));
    }

    private static void parseOption(JsonObject mp, BaseOptionModel option, String name) {
        option.setName(name);
        option.setKind(mp.getString("kind"));
        option.setDisplayName(mp.getString("displayName"));
        option.setGroup(mp.getString("group"));
        option.setLabel(mp.getString("label"));
        option.setRequired(mp.getBooleanOrDefault("required", false));
        option.setType(mp.getString("type"));
        option.setJavaType(mp.getString("javaType"));
        option.setEnums(JsonMapper.asStringList(mp.getCollection("enum")));
        option.setOneOfs(JsonMapper.asStringList(mp.getCollection("oneOf")));
        option.setPrefix(mp.getString("prefix"));
        option.setOptionalPrefix(mp.getString("optionalPrefix"));
        option.setMultiValue(mp.getBooleanOrDefault("multiValue", false));
        option.setDeprecated(mp.getBooleanOrDefault("deprecated", false));
        option.setDeprecationNote(mp.getString("deprecationNote"));
        option.setSecret(mp.getBooleanOrDefault("secret", false));
        option.setDefaultValue(mp.get((Object)"defaultValue"));
        option.setAsPredicate(mp.getBooleanOrDefault("asPredicate", false));
        option.setConfigurationClass(mp.getString("configurationClass"));
        option.setConfigurationField(mp.getString("configurationField"));
        option.setDescription(mp.getString("description"));
    }

    private static void parseGroup(JsonObject mp, MainModel.MainGroupModel option) {
        option.setName(mp.getString("name"));
        option.setDescription(mp.getString("description"));
        option.setSourceType(mp.getString("sourceType"));
    }

    public static JsonObject asJsonObject(List<? extends BaseOptionModel> options) {
        JsonObject json = new JsonObject();
        options.forEach(option -> json.put((Object)option.getName(), (Object)JsonMapper.asJsonObject(option)));
        return json;
    }

    public static JsonObject asJsonObject(BaseOptionModel option) {
        JsonObject prop = new JsonObject();
        prop.put((Object)"kind", (Object)option.getKind());
        prop.put((Object)"displayName", (Object)option.getDisplayName());
        prop.put((Object)"group", (Object)option.getGroup());
        prop.put((Object)"label", (Object)option.getLabel());
        prop.put((Object)"required", (Object)option.isRequired());
        prop.put((Object)"type", (Object)option.getType());
        prop.put((Object)"javaType", (Object)option.getJavaType());
        prop.put((Object)"enum", option.getEnums());
        prop.put((Object)"oneOf", option.getOneOfs());
        prop.put((Object)"prefix", (Object)option.getPrefix());
        prop.put((Object)"optionalPrefix", (Object)option.getOptionalPrefix());
        prop.put((Object)"multiValue", (Object)option.isMultiValue());
        prop.put((Object)"deprecated", (Object)option.isDeprecated());
        prop.put((Object)"deprecationNote", (Object)option.getDeprecationNote());
        prop.put((Object)"secret", (Object)option.isSecret());
        prop.put((Object)"defaultValue", option.getDefaultValue());
        prop.put((Object)"asPredicate", (Object)option.isAsPredicate());
        prop.put((Object)"configurationClass", (Object)option.getConfigurationClass());
        prop.put((Object)"configurationField", (Object)option.getConfigurationField());
        prop.put((Object)"description", (Object)option.getDescription());
        prop.entrySet().removeIf(e -> e.getValue() == null);
        prop.remove((Object)"prefix", (Object)"");
        prop.remove((Object)"optionalPrefix", (Object)"");
        prop.remove((Object)"defaultValue", (Object)"");
        prop.remove((Object)"multiValue", (Object)Boolean.FALSE);
        prop.remove((Object)"asPredicate", (Object)Boolean.FALSE);
        return prop;
    }

    public static MainModel generateMainModel(String json) {
        JsonObject obj = JsonMapper.deserialize(json);
        return JsonMapper.generateMainModel(obj);
    }

    public static MainModel generateMainModel(JsonObject obj) {
        MainModel model = new MainModel();
        JsonArray mgrp = (JsonArray)obj.get((Object)"groups");
        for (Object entry : mgrp) {
            JsonObject mg = (JsonObject)entry;
            MainModel.MainGroupModel group = new MainModel.MainGroupModel();
            JsonMapper.parseGroup(mg, group);
            model.addGroup(group);
        }
        JsonArray mprp = (JsonArray)obj.get((Object)"properties");
        for (Object entry : mprp) {
            JsonObject mp = (JsonObject)entry;
            MainModel.MainOptionModel option = new MainModel.MainOptionModel();
            JsonMapper.parseOption(mp, option, mp.getString("name"));
            option.setSourceType(mp.getString("sourceType"));
            model.addOption(option);
        }
        return model;
    }

    public static JsonObject asJsonObject(MainModel model) {
        JsonObject json = new JsonObject();
        JsonArray groups = new JsonArray();
        for (MainModel.MainGroupModel group : model.getGroups()) {
            JsonObject j = new JsonObject();
            j.put((Object)"name", (Object)group.getName());
            j.put((Object)"description", (Object)group.getDescription());
            j.put((Object)"sourceType", (Object)group.getSourceType());
            groups.add((Object)j);
        }
        json.put((Object)"groups", (Object)groups);
        JsonArray props = new JsonArray();
        for (MainModel.MainOptionModel prop : model.getOptions()) {
            JsonObject j = new JsonObject();
            j.put((Object)"name", (Object)prop.getName());
            j.put((Object)"description", (Object)prop.getDescription());
            j.put((Object)"sourceType", (Object)prop.getSourceType());
            j.put((Object)"type", (Object)prop.getType());
            j.put((Object)"javaType", (Object)prop.getJavaType());
            if (prop.getDefaultValue() != null) {
                j.put((Object)"defaultValue", prop.getDefaultValue());
            }
            if (prop.getEnums() != null) {
                j.put((Object)"enum", prop.getEnums());
            }
            if (prop.isDeprecated()) {
                j.put((Object)"deprecated", (Object)prop.isDeprecated());
            }
            props.add((Object)j);
        }
        json.put((Object)"properties", (Object)props);
        return json;
    }

    public static String createJsonSchema(MainModel model) {
        JsonObject wrapper = JsonMapper.asJsonObject(model);
        return JsonMapper.serialize(wrapper);
    }

    public static JsonObject deserialize(String json) {
        try {
            return (JsonObject)Jsoner.deserialize((String)json);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot parse json", e);
        }
    }

    public static String serialize(Object json) {
        return Jsoner.prettyPrint((String)Jsoner.serialize((Object)json), (int)2, (int)2);
    }

    protected static List<String> asStringList(Collection<?> col) {
        if (col != null) {
            return col.stream().map(Object::toString).collect(Collectors.toList());
        }
        return null;
    }
}

