/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.wal;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import org.apache.camel.component.wal.EntryInfo;
import org.apache.camel.component.wal.Header;
import org.apache.camel.component.wal.LogEntry;
import org.apache.camel.component.wal.PersistedLogEntry;
import org.apache.camel.component.wal.exceptions.BufferTooSmallException;
import org.apache.camel.component.wal.exceptions.InvalidRecordException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogReader
implements AutoCloseable {
    public static final int DEFAULT_CAPACITY = 524288;
    private static final Logger LOG = LoggerFactory.getLogger(LogReader.class);
    private final FileChannel fileChannel;
    private final ByteBuffer ioBuffer;
    private final Header header;

    public LogReader(File logFile) throws IOException {
        this(logFile, 524288);
    }

    public LogReader(File logFile, int capacity) throws IOException {
        this.fileChannel = FileChannel.open(logFile.toPath(), StandardOpenOption.READ);
        this.ioBuffer = ByteBuffer.allocateDirect(capacity);
        this.header = this.readHeader();
    }

    public Header getHeader() {
        return this.header;
    }

    private Header readHeader() throws IOException {
        if (this.fileChannel.size() == 0L) {
            return null;
        }
        this.ioBuffer.clear();
        int bytesRead = this.fileChannel.read(this.ioBuffer);
        if (bytesRead <= 0) {
            throw new IllegalArgumentException("The file does not contain a valid header");
        }
        LOG.trace("Read {} bytes from the file channel", (Object)bytesRead);
        this.ioBuffer.flip();
        byte[] name = new byte[8];
        this.ioBuffer.get(name, 0, 8);
        LOG.trace("File format name: '{}'", (Object)new String(name));
        int fileVersion = this.ioBuffer.getInt();
        LOG.trace("File format version: '{}'", (Object)fileVersion);
        return new Header(new String(name), fileVersion);
    }

    public PersistedLogEntry readEntry() throws IOException {
        if (this.header == null) {
            return null;
        }
        this.logBufferInfo();
        if (this.ioBuffer.hasRemaining()) {
            return this.doReadEntry();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Read it all from the buffer. Fetching again from the channel");
        }
        if (!this.reload()) {
            return null;
        }
        return this.doReadEntry();
    }

    private PersistedLogEntry doReadEntry() throws IOException {
        if (this.ioBuffer.remaining() < 4 && !this.reload()) {
            return null;
        }
        int state = this.ioBuffer.getInt();
        Slot keySlot = this.readSlot();
        Slot valueSlot = this.readSlot();
        EntryInfo entryInfo = EntryInfo.createForPersisted(this.fileChannel.position());
        return new PersistedLogEntry(entryInfo, LogEntry.EntryState.fromInt(state), keySlot.metadata, keySlot.data, valueSlot.metadata, valueSlot.data);
    }

    private Slot readSlot() throws IOException {
        Slot slot = new Slot();
        if (this.ioBuffer.remaining() < 8 && !this.reload()) {
            throw new InvalidRecordException("A data slot within a record is incomplete or malformed");
        }
        slot.metadata = this.ioBuffer.getInt();
        slot.length = this.ioBuffer.getInt();
        if (this.ioBuffer.capacity() < slot.length) {
            throw new BufferTooSmallException(this.ioBuffer.capacity(), slot.length);
        }
        if (this.ioBuffer.remaining() < slot.length && !this.reload()) {
            throw new InvalidRecordException("A data slot within a record is incomplete or malformed");
        }
        slot.data = new byte[slot.length];
        this.ioBuffer.get(slot.data);
        return slot;
    }

    private boolean reload() throws IOException {
        try {
            this.ioBuffer.compact();
            int read = this.fileChannel.read(this.ioBuffer);
            if (read > 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.ioBuffer.flip();
        }
        return false;
    }

    private void logBufferInfo() {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Remaining: {}", (Object)this.ioBuffer.remaining());
            LOG.trace("Position: {}", (Object)this.ioBuffer.position());
            LOG.trace("Has Remaining: {}", (Object)this.ioBuffer.hasRemaining());
        }
    }

    @Override
    public void close() {
        try {
            this.fileChannel.close();
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private static class Slot {
        int metadata;
        int length;
        byte[] data;

        private Slot() {
        }
    }
}

