/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmlrpc;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.xmlrpc.XmlRpcClientConfigurer;
import org.apache.camel.component.xmlrpc.XmlRpcComponent;
import org.apache.camel.component.xmlrpc.XmlRpcProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.SynchronousDelegateProducer;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;

public class XmlRpcEndpoint
extends DefaultEndpoint {
    private String address;
    private XmlRpcClientConfigurer clientConfigurer;
    private XmlRpcClientConfigImpl clientConfig = new XmlRpcClientConfigImpl();

    public XmlRpcEndpoint() {
    }

    public XmlRpcEndpoint(String uri, XmlRpcComponent component, String address) {
        super(uri, (Component)component);
        this.setAddress(address);
    }

    public Producer createProducer() throws Exception {
        XmlRpcProducer answer = new XmlRpcProducer(this);
        if (this.isSynchronous()) {
            return new SynchronousDelegateProducer((Producer)answer);
        }
        return answer;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("This component does not support consuming from this endpoint");
    }

    public boolean isSingleton() {
        return true;
    }

    public XmlRpcClient createClient() throws MalformedURLException {
        XmlRpcClient client = new XmlRpcClient();
        XmlRpcClientConfigImpl config = this.clientConfig.cloneMe();
        config.setServerURL(new URL(this.getAddress()));
        client.setConfig((XmlRpcClientConfig)config);
        if (this.clientConfigurer != null) {
            this.clientConfigurer.configureXmlRpcClient(client);
        }
        return client;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public XmlRpcClientConfigurer getClientConfigurer() {
        return this.clientConfigurer;
    }

    public void setClientConfigurer(XmlRpcClientConfigurer configurer) {
        this.clientConfigurer = configurer;
    }

    public void setClientConfig(XmlRpcClientConfigImpl config) {
        this.clientConfig = config;
    }

    public XmlRpcClientConfigImpl getClientConfig() {
        return this.clientConfig;
    }
}

