/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmlsecurity.processor;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Manifest;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.xmlsecurity.api.ValidationFailedHandler;
import org.apache.camel.component.xmlsecurity.api.XmlSignature2Message;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureChecker;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureFormatException;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureHelper;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureInvalidException;
import org.apache.camel.component.xmlsecurity.processor.XmlSignatureProcessor;
import org.apache.camel.component.xmlsecurity.processor.XmlVerifierConfiguration;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlVerifierProcessor
extends XmlSignatureProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(XmlVerifierProcessor.class);
    private final XmlVerifierConfiguration config;

    public XmlVerifierProcessor(XmlVerifierConfiguration config) {
        this.config = config;
    }

    @Override
    public XmlVerifierConfiguration getConfiguration() {
        return this.config;
    }

    public void process(Exchange exchange) throws Exception {
        InputStream stream = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
        try {
            Message out = exchange.getOut();
            out.copyFrom(exchange.getIn());
            this.verify(stream, out);
            this.clearMessageHeaders(out);
        }
        catch (Exception e) {
            exchange.setOut(null);
            throw e;
        }
        finally {
            IOHelper.close((Closeable)stream, (String)"input stream");
        }
    }

    protected void verify(InputStream input, Message out) throws Exception {
        boolean coreValidity;
        XMLSignatureFactory fac;
        LOG.debug("Verification of XML signature document started");
        Document doc = this.parseInput(input);
        Node signatureNode = this.getSignatureNode(doc);
        try {
            fac = XMLSignatureFactory.getInstance("DOM", "ApacheXMLDSig");
        }
        catch (NoSuchProviderException ex) {
            fac = XMLSignatureFactory.getInstance("DOM");
        }
        KeySelector selector = this.getConfiguration().getKeySelector();
        if (selector == null) {
            throw new IllegalStateException("Wrong configuration. Key selector is missing.");
        }
        DOMValidateContext valContext = new DOMValidateContext(selector, signatureNode);
        valContext.setProperty("javax.xml.crypto.dsig.cacheReference", Boolean.TRUE);
        valContext.setProperty("org.jcp.xml.dsig.validateManifests", Boolean.TRUE);
        if (this.getConfiguration().getSecureValidation() == Boolean.TRUE) {
            valContext.setProperty("org.apache.jcp.xml.dsig.secureValidation", Boolean.TRUE);
            valContext.setProperty("org.jcp.xml.dsig.secureValidation", Boolean.TRUE);
        }
        this.setUriDereferencerAndBaseUri(valContext);
        this.setCryptoContextProperties(valContext);
        XMLSignature signature = fac.unmarshalXMLSignature(valContext);
        this.executeApplicationCheck(out, doc, signature);
        try {
            coreValidity = signature.validate(valContext);
        }
        catch (XMLSignatureException se) {
            throw this.getConfiguration().getValidationFailedHandler().onXMLSignatureException(se);
        }
        boolean goon = coreValidity;
        if (!coreValidity) {
            goon = this.handleSignatureValidationFailed(valContext, signature);
        }
        if (!goon) {
            throw new XmlSignatureInvalidException("");
        }
        LOG.debug("XML signature verified");
        this.map2Message(signature, out, doc);
    }

    private void executeApplicationCheck(final Message out, final Document doc, final XMLSignature signature) throws Exception {
        if (this.getConfiguration().getXmlSignatureChecker() != null) {
            XmlSignatureChecker.Input checkerInput = new XmlSignatureChecker.Input(){

                @Override
                public SignedInfo getSignedInfo() {
                    return signature.getSignedInfo();
                }

                @Override
                public XMLSignature.SignatureValue getSignatureValue() {
                    return signature.getSignatureValue();
                }

                @Override
                public List<? extends XMLObject> getObjects() {
                    return signature.getObjects();
                }

                @Override
                public Document getMessageBodyDocument() {
                    return doc;
                }

                @Override
                public Message getMessage() {
                    return out;
                }

                @Override
                public KeyInfo getKeyInfo() {
                    return signature.getKeyInfo();
                }
            };
            this.getConfiguration().getXmlSignatureChecker().checkBeforeCoreValidation(checkerInput);
        }
    }

    private void map2Message(XMLSignature signature, Message out, final Document messageBodyDocument) throws Exception {
        final ArrayList<Reference> refs = new ArrayList<Reference>(signature.getSignedInfo().getReferences());
        final ArrayList<XMLObject> objs = new ArrayList<XMLObject>(signature.getObjects());
        XmlSignature2Message.Input refsAndObjects = new XmlSignature2Message.Input(){

            @Override
            public List<Reference> getReferences() {
                return refs;
            }

            @Override
            public List<XMLObject> getObjects() {
                return objs;
            }

            @Override
            public Document getMessageBodyDocument() {
                return messageBodyDocument;
            }

            @Override
            public Boolean omitXmlDeclaration() {
                return XmlVerifierProcessor.this.getConfiguration().getOmitXmlDeclaration();
            }

            @Override
            public Object getOutputNodeSearch() {
                return XmlVerifierProcessor.this.getConfiguration().getOutputNodeSearch();
            }

            @Override
            public String getOutputNodeSearchType() {
                return XmlVerifierProcessor.this.getConfiguration().getOutputNodeSearchType();
            }

            @Override
            public Boolean getRemoveSignatureElements() {
                return XmlVerifierProcessor.this.getConfiguration().getRemoveSignatureElements();
            }
        };
        this.getConfiguration().getXmlSignature2Message().mapToMessage(refsAndObjects, out);
    }

    private Node getSignatureNode(Document doc) throws IOException, ParserConfigurationException, XmlSignatureFormatException {
        NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nl.getLength() == 0) {
            throw new XmlSignatureFormatException("Message is not a correct XML signature document: 'Signature' element is missing. Check the sent message.");
        }
        if (nl.getLength() != 1) {
            throw new XmlSignatureFormatException("XML signature document is not supported; it contains more than one signature element. Check the sent message.");
        }
        Node signatureNode = nl.item(0);
        LOG.debug("Signature element found");
        return signatureNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleSignatureValidationFailed(DOMValidateContext valContext, XMLSignature signature) throws Exception {
        ValidationFailedHandler handler = this.getConfiguration().getValidationFailedHandler();
        LOG.debug("handleSignatureValidationFailed called");
        try {
            handler.start();
            XMLSignature.SignatureValue sigValue = signature.getSignatureValue();
            boolean sv = sigValue.validate(valContext);
            if (!sv) {
                handler.signatureValueValidationFailed(sigValue);
            }
            for (Reference ref : signature.getSignedInfo().getReferences()) {
                boolean refValid = ref.validate(valContext);
                if (refValid) continue;
                handler.referenceValidationFailed(ref);
            }
            if (Boolean.TRUE.equals(valContext.getProperty("org.jcp.xml.dsig.validateManifests"))) {
                for (XMLObject xo : signature.getObjects()) {
                    List<XMLStructure> content = xo.getContent();
                    for (XMLStructure xs : content) {
                        if (!(xs instanceof Manifest)) continue;
                        Manifest man = (Manifest)xs;
                        for (Reference ref : man.getReferences()) {
                            boolean refValid = ref.validate(valContext);
                            if (refValid) continue;
                            handler.manifestReferenceValidationFailed(ref);
                        }
                    }
                }
            }
            boolean goon = handler.ignoreCoreValidationFailure();
            LOG.debug("Ignore Core Validation failure: {}", (Object)goon);
            boolean bl = goon;
            return bl;
        }
        finally {
            handler.end();
        }
    }

    protected Document parseInput(InputStream is) throws XmlSignatureFormatException, ParserConfigurationException, IOException {
        try {
            Document doc = XmlSignatureHelper.newDocumentBuilder(this.getConfiguration().getDisallowDoctypeDecl()).parse(is);
            return doc;
        }
        catch (SAXException e) {
            throw new XmlSignatureFormatException("Message has wrong format, it is not a XML signature document. Check the sent message.", e);
        }
    }
}

