/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmlsecurity.api;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.xmlsecurity.api.KeyStoreAndAlias;
import org.apache.camel.support.jsse.KeyStoreParameters;

public class DefaultKeySelector
extends KeySelector
implements CamelContextAware {
    private final KeyStoreAndAlias keyStoreAndAlias = new KeyStoreAndAlias();
    private KeySelectorResult nullKeyResult;
    private CamelContext context;

    public void setKeyStore(KeyStore keyStore) {
        this.keyStoreAndAlias.setKeyStore(keyStore);
    }

    public void setAlias(String alias) {
        this.keyStoreAndAlias.setAlias(alias);
    }

    public void setPassword(String password) {
        if (password == null) {
            this.keyStoreAndAlias.setPassword(null);
        } else {
            this.setPassword(password.toCharArray());
        }
    }

    public void setPassword(char[] password) {
        this.keyStoreAndAlias.setPassword(password);
    }

    public void setKeyStoreParameters(KeyStoreParameters parameters) throws GeneralSecurityException, IOException {
        if (parameters != null) {
            this.keyStoreAndAlias.setKeyStore(parameters.createKeyStore());
        }
    }

    @Override
    public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
        if (this.keyStoreAndAlias.getKeyStore() == null) {
            return this.getNullKeyResult();
        }
        if (this.keyStoreAndAlias.getAlias() == null) {
            return this.getNullKeyResult();
        }
        if (KeySelector.Purpose.VERIFY.equals(purpose)) {
            Certificate cert;
            try {
                cert = this.keyStoreAndAlias.getKeyStore().getCertificate(this.keyStoreAndAlias.getAlias());
            }
            catch (KeyStoreException e) {
                throw new KeySelectorException(e);
            }
            if (cert == null) {
                return this.getNullKeyResult();
            }
            PublicKey key = cert.getPublicKey();
            return this.getKeySelectorResult(key);
        }
        if (KeySelector.Purpose.SIGN.equals(purpose)) {
            Key key;
            block15: {
                if (this.keyStoreAndAlias.getPassword() == null) {
                    return this.getNullKeyResult();
                }
                try {
                    if (this.getCamelContext() != null && this.keyStoreAndAlias.getPassword() != null) {
                        try {
                            String passwordProperty = this.getCamelContext().resolvePropertyPlaceholders(new String(this.keyStoreAndAlias.getPassword()));
                            key = this.keyStoreAndAlias.getKeyStore().getKey(this.keyStoreAndAlias.getAlias(), passwordProperty.toCharArray());
                            break block15;
                        }
                        catch (Exception e) {
                            throw new RuntimeCamelException("Error parsing property value: " + new String(this.keyStoreAndAlias.getPassword()), (Throwable)e);
                        }
                    }
                    key = this.keyStoreAndAlias.getKeyStore().getKey(this.keyStoreAndAlias.getAlias(), this.keyStoreAndAlias.getPassword());
                }
                catch (UnrecoverableKeyException e) {
                    throw new KeySelectorException(e);
                }
                catch (KeyStoreException e) {
                    throw new KeySelectorException(e);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new KeySelectorException(e);
                }
            }
            return this.getKeySelectorResult(key);
        }
        throw new IllegalStateException("Purpose " + purpose + " not supported");
    }

    KeyStore getKeyStore() {
        return this.keyStoreAndAlias.getKeyStore();
    }

    String getAlias() {
        return this.keyStoreAndAlias.getAlias();
    }

    private KeySelectorResult getKeySelectorResult(final Key key) {
        return new KeySelectorResult(){

            @Override
            public Key getKey() {
                return key;
            }
        };
    }

    private KeySelectorResult getNullKeyResult() {
        if (this.nullKeyResult == null) {
            this.nullKeyResult = new KeySelectorResult(){

                @Override
                public Key getKey() {
                    return null;
                }
            };
        }
        return this.nullKeyResult;
    }

    public CamelContext getCamelContext() {
        return this.context;
    }

    public void setCamelContext(CamelContext context) {
        this.context = context;
    }
}

