/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationplatformspec.traits;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import org.apache.camel.v1.integrationplatformspec.traits.AffinityBuilder;
import org.apache.camel.v1.integrationplatformspec.traits.affinity.Configuration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"configuration", "enabled", "nodeAffinityLabels", "podAffinity", "podAffinityLabels", "podAntiAffinity", "podAntiAffinityLabels"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Affinity
implements Editable<AffinityBuilder>,
KubernetesResource {
    @JsonProperty(value="configuration")
    @JsonPropertyDescription(value="Legacy trait configuration parameters. Deprecated: for backward compatibility.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Configuration configuration;
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Can be used to enable or disable a trait. All traits share this common property.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean enabled;
    @JsonProperty(value="nodeAffinityLabels")
    @JsonPropertyDescription(value="Defines a set of nodes the integration pod(s) are eligible to be scheduled on, based on labels on the node.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> nodeAffinityLabels;
    @JsonProperty(value="podAffinity")
    @JsonPropertyDescription(value="Always co-locates multiple replicas of the integration in the same node (default `false`).")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean podAffinity;
    @JsonProperty(value="podAffinityLabels")
    @JsonPropertyDescription(value="Defines a set of pods (namely those matching the label selector, relative to the given namespace) that the integration pod(s) should be co-located with.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> podAffinityLabels;
    @JsonProperty(value="podAntiAffinity")
    @JsonPropertyDescription(value="Never co-locates multiple replicas of the integration in the same node (default `false`).")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean podAntiAffinity;
    @JsonProperty(value="podAntiAffinityLabels")
    @JsonPropertyDescription(value="Defines a set of pods (namely those matching the label selector, relative to the given namespace) that the integration pod(s) should not be co-located with.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> podAntiAffinityLabels;

    public AffinityBuilder edit() {
        return new AffinityBuilder(this);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public List<String> getNodeAffinityLabels() {
        return this.nodeAffinityLabels;
    }

    public void setNodeAffinityLabels(List<String> nodeAffinityLabels) {
        this.nodeAffinityLabels = nodeAffinityLabels;
    }

    public Boolean getPodAffinity() {
        return this.podAffinity;
    }

    public void setPodAffinity(Boolean podAffinity) {
        this.podAffinity = podAffinity;
    }

    public List<String> getPodAffinityLabels() {
        return this.podAffinityLabels;
    }

    public void setPodAffinityLabels(List<String> podAffinityLabels) {
        this.podAffinityLabels = podAffinityLabels;
    }

    public Boolean getPodAntiAffinity() {
        return this.podAntiAffinity;
    }

    public void setPodAntiAffinity(Boolean podAntiAffinity) {
        this.podAntiAffinity = podAntiAffinity;
    }

    public List<String> getPodAntiAffinityLabels() {
        return this.podAntiAffinityLabels;
    }

    public void setPodAntiAffinityLabels(List<String> podAntiAffinityLabels) {
        this.podAntiAffinityLabels = podAntiAffinityLabels;
    }

    public String toString() {
        return "Affinity(configuration=" + this.getConfiguration() + ", enabled=" + this.getEnabled() + ", nodeAffinityLabels=" + this.getNodeAffinityLabels() + ", podAffinity=" + this.getPodAffinity() + ", podAffinityLabels=" + this.getPodAffinityLabels() + ", podAntiAffinity=" + this.getPodAntiAffinity() + ", podAntiAffinityLabels=" + this.getPodAntiAffinityLabels() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Affinity)) {
            return false;
        }
        Affinity other = (Affinity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Boolean this$podAffinity = this.getPodAffinity();
        Boolean other$podAffinity = other.getPodAffinity();
        if (this$podAffinity == null ? other$podAffinity != null : !((Object)this$podAffinity).equals(other$podAffinity)) {
            return false;
        }
        Boolean this$podAntiAffinity = this.getPodAntiAffinity();
        Boolean other$podAntiAffinity = other.getPodAntiAffinity();
        if (this$podAntiAffinity == null ? other$podAntiAffinity != null : !((Object)this$podAntiAffinity).equals(other$podAntiAffinity)) {
            return false;
        }
        Configuration this$configuration = this.getConfiguration();
        Configuration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        List<String> this$nodeAffinityLabels = this.getNodeAffinityLabels();
        List<String> other$nodeAffinityLabels = other.getNodeAffinityLabels();
        if (this$nodeAffinityLabels == null ? other$nodeAffinityLabels != null : !((Object)this$nodeAffinityLabels).equals(other$nodeAffinityLabels)) {
            return false;
        }
        List<String> this$podAffinityLabels = this.getPodAffinityLabels();
        List<String> other$podAffinityLabels = other.getPodAffinityLabels();
        if (this$podAffinityLabels == null ? other$podAffinityLabels != null : !((Object)this$podAffinityLabels).equals(other$podAffinityLabels)) {
            return false;
        }
        List<String> this$podAntiAffinityLabels = this.getPodAntiAffinityLabels();
        List<String> other$podAntiAffinityLabels = other.getPodAntiAffinityLabels();
        return !(this$podAntiAffinityLabels == null ? other$podAntiAffinityLabels != null : !((Object)this$podAntiAffinityLabels).equals(other$podAntiAffinityLabels));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Affinity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Boolean $podAffinity = this.getPodAffinity();
        result = result * 59 + ($podAffinity == null ? 43 : ((Object)$podAffinity).hashCode());
        Boolean $podAntiAffinity = this.getPodAntiAffinity();
        result = result * 59 + ($podAntiAffinity == null ? 43 : ((Object)$podAntiAffinity).hashCode());
        Configuration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        List<String> $nodeAffinityLabels = this.getNodeAffinityLabels();
        result = result * 59 + ($nodeAffinityLabels == null ? 43 : ((Object)$nodeAffinityLabels).hashCode());
        List<String> $podAffinityLabels = this.getPodAffinityLabels();
        result = result * 59 + ($podAffinityLabels == null ? 43 : ((Object)$podAffinityLabels).hashCode());
        List<String> $podAntiAffinityLabels = this.getPodAntiAffinityLabels();
        result = result * 59 + ($podAntiAffinityLabels == null ? 43 : ((Object)$podAntiAffinityLabels).hashCode());
        return result;
    }
}

