/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IFlushable;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.WrappedRunnable;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryMemtable
implements IFlushable {
    private static final Logger logger = LoggerFactory.getLogger(BinaryMemtable.class);
    private final int threshold = DatabaseDescriptor.getBMTThreshold() * 1024 * 1024;
    private final AtomicInteger currentSize = new AtomicInteger(0);
    private boolean isFrozen = false;
    private final Map<DecoratedKey, ByteBuffer> columnFamilies = new NonBlockingHashMap();
    private final Lock lock = new ReentrantLock();
    Condition condition;
    private final IPartitioner partitioner = StorageService.getPartitioner();
    private final ColumnFamilyStore cfs;

    public BinaryMemtable(ColumnFamilyStore cfs) {
        this.cfs = cfs;
        this.condition = this.lock.newCondition();
    }

    boolean isThresholdViolated() {
        return this.currentSize.get() >= this.threshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void put(DecoratedKey key, ByteBuffer buffer) {
        if (this.isThresholdViolated()) {
            this.lock.lock();
            try {
                if (!this.isFrozen) {
                    this.isFrozen = true;
                    this.cfs.submitFlush(this, new CountDownLatch(1));
                    this.cfs.switchBinaryMemtable(key, buffer);
                }
                this.cfs.applyBinary(key, buffer);
            }
            finally {
                this.lock.unlock();
            }
        } else {
            this.resolve(key, buffer);
        }
    }

    public boolean isClean() {
        return this.columnFamilies.isEmpty();
    }

    private void resolve(DecoratedKey key, ByteBuffer buffer) {
        this.columnFamilies.put(key, buffer);
        this.currentSize.addAndGet(buffer.remaining() + key.key.remaining());
    }

    private List<DecoratedKey> getSortedKeys() {
        assert (!this.columnFamilies.isEmpty());
        logger.info("Sorting " + this);
        ArrayList<DecoratedKey> keys = new ArrayList<DecoratedKey>(this.columnFamilies.keySet());
        Collections.sort(keys);
        return keys;
    }

    private SSTableReader writeSortedContents(List<DecoratedKey> sortedKeys) throws IOException {
        logger.info("Writing " + this);
        String path = this.cfs.getFlushPath();
        SSTableWriter writer = new SSTableWriter(path, sortedKeys.size(), this.cfs.metadata, this.cfs.partitioner);
        for (DecoratedKey key : sortedKeys) {
            ByteBuffer bytes = this.columnFamilies.get(key);
            assert (bytes.remaining() > 0);
            writer.append(key, bytes);
        }
        SSTableReader sstable = writer.closeAndOpenReader();
        logger.info("Completed flushing " + writer.getFilename());
        return sstable;
    }

    @Override
    public void flushAndSignal(final CountDownLatch latch, ExecutorService sorter, final ExecutorService writer) {
        sorter.execute(new Runnable(){

            @Override
            public void run() {
                final List sortedKeys = BinaryMemtable.this.getSortedKeys();
                writer.execute(new WrappedRunnable(){

                    @Override
                    public void runMayThrow() throws IOException {
                        BinaryMemtable.this.cfs.addSSTable(BinaryMemtable.this.writeSortedContents(sortedKeys));
                        latch.countDown();
                    }
                });
            }
        });
    }
}

