/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeletedColumn
extends Column {
    private static Logger logger = LoggerFactory.getLogger(DeletedColumn.class);

    public DeletedColumn(ByteBuffer name, int localDeletionTime, long timestamp) {
        this(name, ByteBufferUtil.bytes(localDeletionTime), timestamp);
    }

    public DeletedColumn(ByteBuffer name, ByteBuffer value, long timestamp) {
        super(name, value, timestamp);
    }

    @Override
    public boolean isMarkedForDelete() {
        return true;
    }

    @Override
    public long getMarkedForDeleteAt() {
        return this.timestamp;
    }

    @Override
    public int getLocalDeletionTime() {
        return this.value.getInt(this.value.position());
    }

    @Override
    public IColumn deepCopy() {
        return new DeletedColumn(ByteBufferUtil.clone(this.name), ByteBufferUtil.clone(this.value), this.timestamp);
    }
}

