/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.ICompactSerializer2;
import org.apache.cassandra.io.util.ColumnSortedMap;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SuperColumnSerializer
implements ICompactSerializer2<IColumn> {
    private static Logger logger = LoggerFactory.getLogger(SuperColumnSerializer.class);
    private AbstractType comparator;

    public SuperColumnSerializer(AbstractType comparator) {
        this.comparator = comparator;
    }

    public AbstractType getComparator() {
        return this.comparator;
    }

    @Override
    public void serialize(IColumn column, DataOutput dos) {
        SuperColumn superColumn = (SuperColumn)column;
        ByteBufferUtil.writeWithShortLength(column.name(), dos);
        try {
            dos.writeInt(superColumn.getLocalDeletionTime());
            dos.writeLong(superColumn.getMarkedForDeleteAt());
            Collection<IColumn> columns = column.getSubColumns();
            dos.writeInt(columns.size());
            for (IColumn subColumn : columns) {
                Column.serializer().serialize(subColumn, dos);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IColumn deserialize(DataInput dis) throws IOException {
        ByteBuffer name = ByteBufferUtil.readWithShortLength(dis);
        int localDeleteTime = dis.readInt();
        if (localDeleteTime != Integer.MIN_VALUE && localDeleteTime <= 0) {
            throw new IOException("Invalid localDeleteTime read: " + localDeleteTime);
        }
        long markedForDeleteAt = dis.readLong();
        int size = dis.readInt();
        ColumnSerializer serializer = Column.serializer();
        ColumnSortedMap preSortedMap = new ColumnSortedMap(this.comparator, serializer, dis, size);
        SuperColumn superColumn = new SuperColumn(name, new ConcurrentSkipListMap<ByteBuffer, IColumn>(preSortedMap));
        if (localDeleteTime != Integer.MIN_VALUE && localDeleteTime <= 0) {
            throw new IOException("Invalid localDeleteTime read: " + localDeleteTime);
        }
        superColumn.markForDeleteAt(localDeleteTime, markedForDeleteAt);
        return superColumn;
    }
}

