/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.io.AbstractCompactedRow;
import org.apache.cassandra.io.ICompactionInfo;
import org.apache.cassandra.io.LazilyCompactedRow;
import org.apache.cassandra.io.PrecompactedRow;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableScanner;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.ReducingIterator;
import org.apache.commons.collections.iterators.CollatingIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionIterator
extends ReducingIterator<SSTableIdentityIterator, AbstractCompactedRow>
implements Closeable,
ICompactionInfo {
    private static Logger logger = LoggerFactory.getLogger(CompactionIterator.class);
    public static final int FILE_BUFFER_SIZE = 0x100000;
    protected final List<SSTableIdentityIterator> rows = new ArrayList<SSTableIdentityIterator>();
    private final ColumnFamilyStore cfs;
    private final int gcBefore;
    private final boolean major;
    private long totalBytes = 0L;
    private long bytesRead = 0L;
    private long row = 0L;

    public CompactionIterator(ColumnFamilyStore cfs, Iterable<SSTableReader> sstables, int gcBefore, boolean major) throws IOException {
        this(cfs, (Iterator)CompactionIterator.getCollatingIterator(sstables), gcBefore, major);
    }

    protected CompactionIterator(ColumnFamilyStore cfs, Iterator iter, int gcBefore, boolean major) {
        super(iter);
        for (SSTableScanner scanner : this.getScanners()) {
            this.totalBytes += scanner.getFileLength();
        }
        this.cfs = cfs;
        this.gcBefore = gcBefore;
        this.major = major;
    }

    protected static CollatingIterator getCollatingIterator(Iterable<SSTableReader> sstables) throws IOException {
        CollatingIterator iter = FBUtilities.getCollatingIterator();
        for (SSTableReader sstable : sstables) {
            iter.addIterator((Iterator)sstable.getDirectScanner(0x100000));
        }
        return iter;
    }

    @Override
    protected boolean isEqual(SSTableIdentityIterator o1, SSTableIdentityIterator o2) {
        return o1.getKey().equals(o2.getKey());
    }

    @Override
    public void reduce(SSTableIdentityIterator current) {
        this.rows.add(current);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AbstractCompactedRow getReduced() {
        assert (this.rows.size() > 0);
        try {
            AbstractCompactedRow compactedRow = this.getCompactedRow();
            AbstractCompactedRow abstractCompactedRow = compactedRow.isEmpty() ? null : compactedRow;
            return abstractCompactedRow;
        }
        finally {
            this.rows.clear();
            if (this.row++ % 1000L == 0L) {
                this.bytesRead = 0L;
                for (SSTableScanner scanner : this.getScanners()) {
                    this.bytesRead += scanner.getFilePointer();
                }
            }
        }
    }

    protected AbstractCompactedRow getCompactedRow() {
        long rowSize = 0L;
        for (SSTableIdentityIterator row : this.rows) {
            rowSize += row.dataSize;
        }
        if (rowSize > (long)DatabaseDescriptor.getInMemoryCompactionLimit()) {
            logger.info(String.format("Compacting large row %s (%d bytes) incrementally", ByteBufferUtil.bytesToHex(this.rows.get((int)0).getKey().key), rowSize));
            return new LazilyCompactedRow(this.cfs, this.rows, this.major, this.gcBefore);
        }
        return new PrecompactedRow(this.cfs, this.rows, this.major, this.gcBefore);
    }

    @Override
    public void close() throws IOException {
        for (SSTableScanner scanner : this.getScanners()) {
            scanner.close();
        }
    }

    protected Iterable<SSTableScanner> getScanners() {
        return ((CollatingIterator)this.source).getIterators();
    }

    @Override
    public long getTotalBytes() {
        return this.totalBytes;
    }

    @Override
    public long getBytesComplete() {
        return this.bytesRead;
    }

    @Override
    public String getTaskType() {
        return this.major ? "Major" : "Minor";
    }
}

