/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.TokenMetadata;

public class OldNetworkTopologyStrategy
extends AbstractReplicationStrategy {
    public OldNetworkTopologyStrategy(String table, TokenMetadata tokenMetadata, IEndpointSnitch snitch, Map<String, String> configOptions) {
        super(table, tokenMetadata, snitch, configOptions);
    }

    @Override
    public List<InetAddress> calculateNaturalEndpoints(Token token, TokenMetadata metadata) {
        Token t;
        int replicas = this.getReplicationFactor();
        ArrayList<InetAddress> endpoints = new ArrayList<InetAddress>(replicas);
        ArrayList<Token> tokens = metadata.sortedTokens();
        if (tokens.isEmpty()) {
            return endpoints;
        }
        Iterator<Token> iter = TokenMetadata.ringIterator(tokens, token, false);
        Token primaryToken = iter.next();
        endpoints.add(metadata.getEndpoint(primaryToken));
        boolean bDataCenter = false;
        boolean bOtherRack = false;
        while (endpoints.size() < replicas && iter.hasNext()) {
            t = iter.next();
            if (!this.snitch.getDatacenter(metadata.getEndpoint(primaryToken)).equals(this.snitch.getDatacenter(metadata.getEndpoint(t)))) {
                if (bDataCenter) continue;
                endpoints.add(metadata.getEndpoint(t));
                bDataCenter = true;
                continue;
            }
            if (this.snitch.getRack(metadata.getEndpoint(primaryToken)).equals(this.snitch.getRack(metadata.getEndpoint(t))) || !this.snitch.getDatacenter(metadata.getEndpoint(primaryToken)).equals(this.snitch.getDatacenter(metadata.getEndpoint(t))) || bOtherRack) continue;
            endpoints.add(metadata.getEndpoint(t));
            bOtherRack = true;
        }
        if (endpoints.size() < replicas) {
            iter = TokenMetadata.ringIterator(tokens, token, false);
            while (endpoints.size() < replicas && iter.hasNext()) {
                t = iter.next();
                if (endpoints.contains(metadata.getEndpoint(t))) continue;
                endpoints.add(metadata.getEndpoint(t));
            }
            if (endpoints.size() < replicas) {
                throw new IllegalStateException(String.format("replication factor (%s) exceeds number of endpoints (%s)", replicas, endpoints.size()));
            }
        }
        return endpoints;
    }
}

