/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.DigestMismatchException;
import org.apache.cassandra.service.IResponseResolver;
import org.apache.cassandra.service.ReadResponseResolver;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.utils.SimpleCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadCallback<T>
implements IAsyncCallback {
    protected static final Logger logger = LoggerFactory.getLogger(ReadCallback.class);
    public final IResponseResolver<T> resolver;
    protected final SimpleCondition condition = new SimpleCondition();
    private final long startTime;
    protected final int blockfor;

    public ReadCallback(IResponseResolver<T> resolver, ConsistencyLevel consistencyLevel, String table) {
        this.blockfor = this.determineBlockFor(consistencyLevel, table);
        this.resolver = resolver;
        this.startTime = System.currentTimeMillis();
        logger.debug("ReadCallback blocking for {} responses", (Object)this.blockfor);
    }

    public T get() throws TimeoutException, DigestMismatchException, IOException {
        boolean success;
        long timeout = DatabaseDescriptor.getRpcTimeout() - (System.currentTimeMillis() - this.startTime);
        try {
            success = this.condition.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new AssertionError((Object)ex);
        }
        if (!success) {
            StringBuilder sb = new StringBuilder("");
            for (Message message : this.resolver.getMessages()) {
                sb.append(message.getFrom()).append(", ");
            }
            throw new TimeoutException("Operation timed out - received only " + this.resolver.getMessageCount() + " responses from " + sb.toString() + " .");
        }
        return this.blockfor == 1 ? this.resolver.getData() : this.resolver.resolve();
    }

    @Override
    public void response(Message message) {
        this.resolver.preprocess(message);
        if (this.resolver.getMessageCount() < this.blockfor) {
            return;
        }
        if (this.resolver.isDataPresent()) {
            this.condition.signal();
        }
    }

    public void response(ReadResponse result) {
        ((ReadResponseResolver)this.resolver).injectPreProcessed(result);
        if (this.resolver.getMessageCount() < this.blockfor) {
            return;
        }
        if (this.resolver.isDataPresent()) {
            this.condition.signal();
        }
    }

    public int determineBlockFor(ConsistencyLevel consistencyLevel, String table) {
        switch (consistencyLevel) {
            case ONE: 
            case ANY: {
                return 1;
            }
            case QUORUM: {
                return Table.open(table).getReplicationStrategy().getReplicationFactor() / 2 + 1;
            }
            case ALL: {
                return Table.open(table).getReplicationStrategy().getReplicationFactor();
            }
        }
        throw new UnsupportedOperationException("invalid consistency level: " + (Object)((Object)consistencyLevel));
    }

    public void assureSufficientLiveNodes(Collection<InetAddress> endpoints) throws UnavailableException {
        if (endpoints.size() < this.blockfor) {
            throw new UnavailableException();
        }
    }
}

