/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadCommandSerializer;
import org.apache.cassandra.db.SliceFromReadCommand;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.utils.ByteBufferUtil;

class SliceFromReadCommandSerializer
extends ReadCommandSerializer {
    SliceFromReadCommandSerializer() {
    }

    @Override
    public void serialize(ReadCommand rm, DataOutputStream dos) throws IOException {
        SliceFromReadCommand realRM = (SliceFromReadCommand)rm;
        dos.writeBoolean(realRM.isDigestQuery());
        dos.writeUTF(realRM.table);
        ByteBufferUtil.writeWithShortLength(realRM.key, dos);
        realRM.queryPath.serialize(dos);
        ByteBufferUtil.writeWithShortLength(realRM.start, dos);
        ByteBufferUtil.writeWithShortLength(realRM.finish, dos);
        dos.writeBoolean(realRM.reversed);
        dos.writeInt(realRM.count);
    }

    @Override
    public ReadCommand deserialize(DataInputStream dis) throws IOException {
        boolean isDigest = dis.readBoolean();
        SliceFromReadCommand rm = new SliceFromReadCommand(dis.readUTF(), ByteBufferUtil.readWithShortLength(dis), QueryPath.deserialize(dis), ByteBufferUtil.readWithShortLength(dis), ByteBufferUtil.readWithShortLength(dis), dis.readBoolean(), dis.readInt());
        rm.setDigestQuery(isDigest);
        return rm;
    }
}

