/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.UUID;
import org.apache.cassandra.utils.FBUtilities;
import org.safehaus.uuid.EthernetAddress;
import org.safehaus.uuid.UUIDGenerator;

public class UUIDGen {
    public static UUID makeType1UUIDFromHost(InetAddress addr) {
        MessageDigest digest = FBUtilities.threadLocalMD5Digest();
        digest.update(addr.getAddress());
        byte[] md5 = digest.digest();
        byte[] fauxMac = new byte[6];
        System.arraycopy(md5, 0, fauxMac, 0, Math.min(md5.length, fauxMac.length));
        return UUIDGen.getUUID(ByteBuffer.wrap(UUIDGenerator.getInstance().generateTimeBasedUUID(new EthernetAddress(fauxMac)).toByteArray()));
    }

    public static UUID getUUID(ByteBuffer raw) {
        return new UUID(raw.getLong(raw.position()), raw.getLong(raw.position() + 8));
    }

    public static byte[] decompose(UUID uuid) {
        long most = uuid.getMostSignificantBits();
        long least = uuid.getLeastSignificantBits();
        byte[] b = new byte[16];
        for (int i = 0; i < 8; ++i) {
            b[i] = (byte)(most >>> (7 - i) * 8);
            b[8 + i] = (byte)(least >>> (7 - i) * 8);
        }
        return b;
    }
}

