/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql.TermType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.LexicalUUIDType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.thrift.InvalidRequestException;

public class Term {
    private final String text;
    private final TermType type;

    public Term(String text, int type) {
        this.text = text == null ? "" : text;
        this.type = TermType.forInt(type);
    }

    public Term(String text, TermType type) {
        this.text = text == null ? "" : text;
        this.type = type;
    }

    protected Term() {
        this.text = "";
        this.type = TermType.STRING;
    }

    public String getText() {
        return this.text;
    }

    public ByteBuffer getByteBuffer(AbstractType<?> validator) throws InvalidRequestException {
        try {
            return validator.fromString(this.text);
        }
        catch (MarshalException e) {
            throw new InvalidRequestException(e.getMessage());
        }
    }

    public ByteBuffer getByteBuffer() throws InvalidRequestException {
        switch (this.type) {
            case STRING: {
                return AsciiType.instance.fromString(this.text);
            }
            case INTEGER: {
                return IntegerType.instance.fromString(this.text);
            }
            case UUID: {
                return LexicalUUIDType.instance.fromString(this.text);
            }
        }
        return null;
    }

    public TermType getType() {
        return this.type;
    }

    public String toString() {
        return String.format("Term(%s, type=%s)", new Object[]{this.getText(), this.type});
    }
}

