/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql.Term;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.InvalidRequestException;

public class UpdateStatement {
    public static final ConsistencyLevel defaultConsistency = ConsistencyLevel.ONE;
    private String columnFamily;
    private ConsistencyLevel cLevel = null;
    private Map<Term, Term> columns;
    private List<Term> columnNames;
    private List<Term> columnValues;
    private Term key;

    public UpdateStatement(String columnFamily, ConsistencyLevel cLevel, Map<Term, Term> columns, Term key) {
        this.columnFamily = columnFamily;
        this.cLevel = cLevel;
        this.columns = columns;
        this.key = key;
    }

    public UpdateStatement(String columnFamily, Map<Term, Term> columns, Term key) {
        this(columnFamily, null, columns, key);
    }

    public UpdateStatement(String columnFamily, ConsistencyLevel cLevel, List<Term> columnNames, List<Term> columnValues, Term key) {
        this.columnFamily = columnFamily;
        this.cLevel = cLevel;
        this.columnNames = columnNames;
        this.columnValues = columnValues;
        this.key = key;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.cLevel != null ? this.cLevel : defaultConsistency;
    }

    public boolean isSetConsistencyLevel() {
        return this.cLevel != null;
    }

    public String getColumnFamily() {
        return this.columnFamily;
    }

    public Term getKey() {
        return this.key;
    }

    public Map<Term, Term> getColumns() throws InvalidRequestException {
        if (this.columns != null) {
            return this.columns;
        }
        if (this.columnNames.size() != this.columnValues.size()) {
            throw new InvalidRequestException("unmatched column names/values");
        }
        if (this.columnNames.size() < 1) {
            throw new InvalidRequestException("no columns specified for INSERT");
        }
        this.columns = new HashMap<Term, Term>();
        for (int i = 0; i < this.columnNames.size(); ++i) {
            this.columns.put(this.columnNames.get(i), this.columnValues.get(i));
        }
        return this.columns;
    }

    public String toString() {
        return String.format("UpdateStatement(columnFamily=%s, key=%s, columns=%s, consistency=%s)", this.columnFamily, this.key, this.columns, this.cLevel);
    }

    public AbstractType<?> getKeyType(String keyspace) {
        return DatabaseDescriptor.getCFMetaData(keyspace, this.columnFamily).getKeyValidator();
    }

    public AbstractType<?> getComparator(String keyspace) {
        return DatabaseDescriptor.getComparator(keyspace, this.columnFamily);
    }

    public AbstractType<?> getValueValidator(String keyspace, ByteBuffer column) {
        return DatabaseDescriptor.getValueValidator(keyspace, this.columnFamily, column);
    }
}

