/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.CounterColumn;
import org.apache.cassandra.db.CounterUpdateColumn;
import org.apache.cassandra.db.DeletedColumn;
import org.apache.cassandra.db.ExpiringColumn;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.io.IColumnSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnSerializer
implements IColumnSerializer {
    private static final Logger logger = LoggerFactory.getLogger(ColumnSerializer.class);
    public static final int DELETION_MASK = 1;
    public static final int EXPIRATION_MASK = 2;
    public static final int COUNTER_MASK = 4;
    public static final int COUNTER_UPDATE_MASK = 8;

    @Override
    public void serialize(IColumn column, DataOutput dos) {
        assert (column.name().remaining() > 0);
        ByteBufferUtil.writeWithShortLength(column.name(), dos);
        try {
            dos.writeByte(column.serializationFlags());
            if (column instanceof CounterColumn) {
                dos.writeLong(((CounterColumn)column).timestampOfLastDelete());
            } else if (column instanceof ExpiringColumn) {
                dos.writeInt(((ExpiringColumn)column).getTimeToLive());
                dos.writeInt(column.getLocalDeletionTime());
            }
            dos.writeLong(column.timestamp());
            ByteBufferUtil.writeWithLength(column.value(), dos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Column deserialize(DataInput dis) throws IOException {
        return this.deserialize(dis, null, false);
    }

    public Column deserialize(DataInput dis, ColumnFamilyStore interner, boolean fromRemote) throws IOException {
        return this.deserialize(dis, interner, fromRemote, (int)(System.currentTimeMillis() / 1000L));
    }

    @Override
    public Column deserialize(DataInput dis, ColumnFamilyStore interner, boolean fromRemote, int expireBefore) throws IOException {
        int b;
        ByteBuffer name = ByteBufferUtil.readWithShortLength(dis);
        if (name.remaining() <= 0) {
            throw new CorruptColumnException("invalid column name length " + name.remaining());
        }
        if (interner != null) {
            name = interner.maybeIntern(name);
        }
        if (((b = dis.readUnsignedByte()) & 4) != 0) {
            long timestampOfLastDelete = dis.readLong();
            long ts = dis.readLong();
            ByteBuffer value = ByteBufferUtil.readWithLength(dis);
            if (fromRemote) {
                value = CounterContext.instance().clearAllDelta(value);
            }
            return new CounterColumn(name, value, ts, timestampOfLastDelete);
        }
        if ((b & 2) != 0) {
            int ttl = dis.readInt();
            int expiration = dis.readInt();
            long ts = dis.readLong();
            ByteBuffer value = ByteBufferUtil.readWithLength(dis);
            if (expiration < expireBefore) {
                ByteBuffer bytes = ByteBuffer.allocate(4);
                bytes.putInt(expiration);
                bytes.rewind();
                return new DeletedColumn(name, bytes, ts);
            }
            return new ExpiringColumn(name, value, ts, ttl, expiration);
        }
        long ts = dis.readLong();
        ByteBuffer value = ByteBufferUtil.readWithLength(dis);
        return (b & 8) != 0 ? new CounterUpdateColumn(name, value, ts) : ((b & 1) == 0 ? new Column(name, value, ts) : new DeletedColumn(name, value, ts));
    }

    private static class CorruptColumnException
    extends IOException {
        public CorruptColumnException(String s) {
            super(s);
        }
    }
}

