/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.RetryingScheduledThreadPoolExecutor;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.GossipDigest;
import org.apache.cassandra.gms.GossipDigestAck2Message;
import org.apache.cassandra.gms.GossipDigestAckMessage;
import org.apache.cassandra.gms.GossipDigestSynMessage;
import org.apache.cassandra.gms.HeartBeatState;
import org.apache.cassandra.gms.IEndpointStateChangeSubscriber;
import org.apache.cassandra.gms.IFailureDetectionEventListener;
import org.apache.cassandra.gms.IFailureDetector;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessageProducer;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Gossiper
implements IFailureDetectionEventListener {
    private static final RetryingScheduledThreadPoolExecutor executor = new RetryingScheduledThreadPoolExecutor("GossipTasks");
    static final ApplicationState[] STATES = ApplicationState.values();
    static final List<String> DEAD_STATES = Arrays.asList("removing", "removed", "LEFT");
    private ScheduledFuture<?> scheduledGossipTask;
    public static final int intervalInMillis = 1000;
    public static final int QUARANTINE_DELAY = 60000;
    private static Logger logger = LoggerFactory.getLogger(Gossiper.class);
    public static final Gossiper instance = new Gossiper();
    private long aVeryLongTime = 259200000L;
    private long FatClientTimeout = 30000L;
    private Random random = new Random();
    private Comparator<InetAddress> inetcomparator = new Comparator<InetAddress>(){

        @Override
        public int compare(InetAddress addr1, InetAddress addr2) {
            return addr1.getHostAddress().compareTo(addr2.getHostAddress());
        }
    };
    private List<IEndpointStateChangeSubscriber> subscribers = new CopyOnWriteArrayList<IEndpointStateChangeSubscriber>();
    private Set<InetAddress> liveEndpoints = new ConcurrentSkipListSet<InetAddress>(this.inetcomparator);
    private Map<InetAddress, Long> unreachableEndpoints = new ConcurrentHashMap<InetAddress, Long>();
    private Set<InetAddress> seeds = new ConcurrentSkipListSet<InetAddress>(this.inetcomparator);
    Map<InetAddress, EndpointState> endpointStateMap = new ConcurrentHashMap<InetAddress, EndpointState>();
    private Map<InetAddress, Long> justRemovedEndpoints = new ConcurrentHashMap<InetAddress, Long>();
    private final ConcurrentMap<InetAddress, Integer> versions = new NonBlockingHashMap();

    private Gossiper() {
        FailureDetector.instance.registerFailureDetectionEventListener(this);
    }

    public void register(IEndpointStateChangeSubscriber subscriber) {
        this.subscribers.add(subscriber);
    }

    public void unregister(IEndpointStateChangeSubscriber subscriber) {
        this.subscribers.remove(subscriber);
    }

    public void setVersion(InetAddress address, int version) {
        logger.debug("Setting version {} for {}", (Object)version, (Object)address);
        this.versions.put(address, version);
    }

    public void resetVersion(InetAddress endpoint) {
        logger.debug("Reseting version for {}", (Object)endpoint);
        this.versions.remove(endpoint);
    }

    public Integer getVersion(InetAddress address) {
        Integer v = (Integer)this.versions.get(address);
        if (v == null) {
            logger.trace("Assuming current protocol version for {}", (Object)address);
            return 2;
        }
        return v;
    }

    public Set<InetAddress> getLiveMembers() {
        HashSet<InetAddress> liveMbrs = new HashSet<InetAddress>(this.liveEndpoints);
        if (!liveMbrs.contains(FBUtilities.getLocalAddress())) {
            liveMbrs.add(FBUtilities.getLocalAddress());
        }
        return liveMbrs;
    }

    public Set<InetAddress> getUnreachableMembers() {
        return this.unreachableEndpoints.keySet();
    }

    public long getEndpointDowntime(InetAddress ep) {
        Long downtime = this.unreachableEndpoints.get(ep);
        if (downtime != null) {
            return System.currentTimeMillis() - downtime;
        }
        return 0L;
    }

    @Override
    public void convict(InetAddress endpoint, double phi) {
        EndpointState epState = this.endpointStateMap.get(endpoint);
        if (epState.isAlive()) {
            this.markDead(endpoint, epState);
        }
    }

    int getMaxEndpointStateVersion(EndpointState epState) {
        int maxVersion = epState.getHeartBeatState().getHeartBeatVersion();
        for (VersionedValue value : epState.getApplicationStateMap().values()) {
            maxVersion = Math.max(maxVersion, value.version);
        }
        return maxVersion;
    }

    private void evictFromMembership(InetAddress endpoint) {
        this.unreachableEndpoints.remove(endpoint);
        this.endpointStateMap.remove(endpoint);
        this.justRemovedEndpoints.put(endpoint, System.currentTimeMillis());
        if (logger.isDebugEnabled()) {
            logger.debug("evicting " + endpoint + " from gossip");
        }
    }

    public void removeEndpoint(InetAddress endpoint) {
        for (IEndpointStateChangeSubscriber subscriber : this.subscribers) {
            subscriber.onRemove(endpoint);
        }
        this.liveEndpoints.remove(endpoint);
        this.unreachableEndpoints.remove(endpoint);
        FailureDetector.instance.remove(endpoint);
        this.versions.remove(endpoint);
        this.justRemovedEndpoints.put(endpoint, System.currentTimeMillis());
        if (logger.isDebugEnabled()) {
            logger.debug("removing endpoint " + endpoint);
        }
    }

    private void makeRandomGossipDigest(List<GossipDigest> gDigests) {
        int generation = 0;
        int maxVersion = 0;
        ArrayList<InetAddress> endpoints = new ArrayList<InetAddress>(this.endpointStateMap.keySet());
        Collections.shuffle(endpoints, this.random);
        for (InetAddress endpoint : endpoints) {
            EndpointState epState = this.endpointStateMap.get(endpoint);
            if (epState != null) {
                generation = epState.getHeartBeatState().getGeneration();
                maxVersion = this.getMaxEndpointStateVersion(epState);
            }
            gDigests.add(new GossipDigest(endpoint, generation, maxVersion));
        }
        if (logger.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (GossipDigest gDigest : gDigests) {
                sb.append(gDigest);
                sb.append(" ");
            }
            logger.trace("Gossip Digests are : " + sb.toString());
        }
    }

    public void advertiseRemoving(InetAddress endpoint, Token token, Token mytoken) {
        EndpointState epState = this.endpointStateMap.get(endpoint);
        int generation = epState.getHeartBeatState().getGeneration();
        logger.info("Removing token: " + token);
        logger.info("Sleeping for 30000ms to ensure " + endpoint + " does not change");
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        epState = this.endpointStateMap.get(endpoint);
        if (epState.getHeartBeatState().getGeneration() != generation) {
            throw new RuntimeException("Endpoint " + endpoint + " generation changed while trying to remove it");
        }
        logger.info("Advertising removal for " + endpoint);
        epState.updateTimestamp();
        epState.getHeartBeatState().forceNewerGenerationUnsafe();
        epState.addApplicationState(ApplicationState.STATUS, StorageService.instance.valueFactory.removingNonlocal(token));
        epState.addApplicationState(ApplicationState.REMOVAL_COORDINATOR, StorageService.instance.valueFactory.removalCoordinator(mytoken));
        this.endpointStateMap.put(endpoint, epState);
    }

    public void advertiseTokenRemoved(InetAddress endpoint, Token token) {
        EndpointState epState = this.endpointStateMap.get(endpoint);
        epState.updateTimestamp();
        epState.getHeartBeatState().forceNewerGenerationUnsafe();
        epState.addApplicationState(ApplicationState.STATUS, StorageService.instance.valueFactory.removedNonlocal(token));
        logger.info("Completing removal of " + endpoint);
        this.endpointStateMap.put(endpoint, epState);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean isKnownEndpoint(InetAddress endpoint) {
        return this.endpointStateMap.containsKey(endpoint);
    }

    public int getCurrentGenerationNumber(InetAddress endpoint) {
        return this.endpointStateMap.get(endpoint).getHeartBeatState().getGeneration();
    }

    Message makeGossipDigestSynMessage(List<GossipDigest> gDigests, int version) throws IOException {
        GossipDigestSynMessage gDigestMessage = new GossipDigestSynMessage(DatabaseDescriptor.getClusterName(), gDigests);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        GossipDigestSynMessage.serializer().serialize(gDigestMessage, dos, version);
        return new Message(FBUtilities.getLocalAddress(), StorageService.Verb.GOSSIP_DIGEST_SYN, bos.toByteArray(), version);
    }

    Message makeGossipDigestAckMessage(GossipDigestAckMessage gDigestAckMessage, int version) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        GossipDigestAckMessage.serializer().serialize(gDigestAckMessage, dos, version);
        return new Message(FBUtilities.getLocalAddress(), StorageService.Verb.GOSSIP_DIGEST_ACK, bos.toByteArray(), version);
    }

    Message makeGossipDigestAck2Message(GossipDigestAck2Message gDigestAck2Message, int version) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        GossipDigestAck2Message.serializer().serialize(gDigestAck2Message, dos, version);
        return new Message(FBUtilities.getLocalAddress(), StorageService.Verb.GOSSIP_DIGEST_ACK2, bos.toByteArray(), version);
    }

    private boolean sendGossip(MessageProducer prod, Set<InetAddress> epSet) {
        int size = epSet.size();
        if (size < 1) {
            return false;
        }
        ArrayList<InetAddress> liveEndpoints = new ArrayList<InetAddress>(epSet);
        int index = size == 1 ? 0 : this.random.nextInt(size);
        InetAddress to = (InetAddress)liveEndpoints.get(index);
        if (logger.isTraceEnabled()) {
            logger.trace("Sending a GossipDigestSynMessage to {} ...", (Object)to);
        }
        try {
            MessagingService.instance().sendOneWay(prod.getMessage(this.getVersion(to)), to);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
        return this.seeds.contains(to);
    }

    private boolean doGossipToLiveMember(MessageProducer prod) {
        int size = this.liveEndpoints.size();
        if (size == 0) {
            return false;
        }
        return this.sendGossip(prod, this.liveEndpoints);
    }

    private void doGossipToUnreachableMember(MessageProducer prod) {
        double liveEndpointCount = this.liveEndpoints.size();
        double unreachableEndpointCount = this.unreachableEndpoints.size();
        if (unreachableEndpointCount > 0.0) {
            double prob = unreachableEndpointCount / (liveEndpointCount + 1.0);
            double randDbl = this.random.nextDouble();
            if (randDbl < prob) {
                this.sendGossip(prod, this.unreachableEndpoints.keySet());
            }
        }
    }

    private void doGossipToSeed(MessageProducer prod) {
        int size = this.seeds.size();
        if (size > 0) {
            if (size == 1 && this.seeds.contains(FBUtilities.getLocalAddress())) {
                return;
            }
            if (this.liveEndpoints.size() == 0) {
                this.sendGossip(prod, this.seeds);
            } else {
                double probability = (double)this.seeds.size() / (double)(this.liveEndpoints.size() + this.unreachableEndpoints.size());
                double randDbl = this.random.nextDouble();
                if (randDbl <= probability) {
                    this.sendGossip(prod, this.seeds);
                }
            }
        }
    }

    private void doStatusCheck() {
        long now = System.currentTimeMillis();
        Set<InetAddress> eps = this.endpointStateMap.keySet();
        for (InetAddress inetAddress : eps) {
            if (inetAddress.equals(FBUtilities.getLocalAddress())) continue;
            FailureDetector.instance.interpret(inetAddress);
            EndpointState epState = this.endpointStateMap.get(inetAddress);
            if (epState == null) continue;
            long duration = now - epState.getUpdateTimestamp();
            if (StorageService.instance.getTokenMetadata().isMember(inetAddress)) {
                epState.setHasToken(true);
            }
            if (!(epState.hasToken() || epState.isAlive() || this.justRemovedEndpoints.containsKey(inetAddress) || duration <= this.FatClientTimeout)) {
                logger.info("FatClient " + inetAddress + " has been silent for " + this.FatClientTimeout + "ms, removing from gossip");
                this.removeEndpoint(inetAddress);
                this.evictFromMembership(inetAddress);
            }
            if (epState.isAlive() || duration <= this.aVeryLongTime || StorageService.instance.getTokenMetadata().isMember(inetAddress)) continue;
            this.evictFromMembership(inetAddress);
        }
        if (!this.justRemovedEndpoints.isEmpty()) {
            for (Map.Entry entry : this.justRemovedEndpoints.entrySet()) {
                if (now - (Long)entry.getValue() <= 60000L) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("60000 elapsed, " + entry.getKey() + " gossip quarantine over");
                }
                this.justRemovedEndpoints.remove(entry.getKey());
            }
        }
    }

    public EndpointState getEndpointStateForEndpoint(InetAddress ep) {
        return this.endpointStateMap.get(ep);
    }

    public Set<Map.Entry<InetAddress, EndpointState>> getEndpointStates() {
        return this.endpointStateMap.entrySet();
    }

    EndpointState getStateForVersionBiggerThan(InetAddress forEndpoint, int version) {
        EndpointState epState = this.endpointStateMap.get(forEndpoint);
        EndpointState reqdEndpointState = null;
        if (epState != null) {
            int localHbVersion = epState.getHeartBeatState().getHeartBeatVersion();
            if (localHbVersion > version) {
                reqdEndpointState = new EndpointState(epState.getHeartBeatState());
                if (logger.isTraceEnabled()) {
                    logger.trace("local heartbeat version " + localHbVersion + " greater than " + version + " for " + forEndpoint);
                }
            }
            for (Map.Entry<ApplicationState, VersionedValue> entry : epState.getApplicationStateMap().entrySet()) {
                VersionedValue value = entry.getValue();
                if (value.version <= version) continue;
                if (reqdEndpointState == null) {
                    reqdEndpointState = new EndpointState(epState.getHeartBeatState());
                }
                ApplicationState key = entry.getKey();
                if (logger.isTraceEnabled()) {
                    logger.trace("Adding state " + (Object)((Object)key) + ": " + value.value);
                }
                reqdEndpointState.addApplicationState(key, value);
            }
        }
        return reqdEndpointState;
    }

    public int compareEndpointStartup(InetAddress addr1, InetAddress addr2) {
        EndpointState ep1 = this.getEndpointStateForEndpoint(addr1);
        EndpointState ep2 = this.getEndpointStateForEndpoint(addr2);
        assert (ep1 != null && ep2 != null);
        return ep1.getHeartBeatState().getGeneration() - ep2.getHeartBeatState().getGeneration();
    }

    void notifyFailureDetector(List<GossipDigest> gDigests) {
        for (GossipDigest gDigest : gDigests) {
            this.notifyFailureDetector(gDigest.endpoint, this.endpointStateMap.get(gDigest.endpoint));
        }
    }

    void notifyFailureDetector(Map<InetAddress, EndpointState> remoteEpStateMap) {
        for (Map.Entry<InetAddress, EndpointState> entry : remoteEpStateMap.entrySet()) {
            this.notifyFailureDetector(entry.getKey(), entry.getValue());
        }
    }

    void notifyFailureDetector(InetAddress endpoint, EndpointState remoteEndpointState) {
        IFailureDetector fd = FailureDetector.instance;
        EndpointState localEndpointState = this.endpointStateMap.get(endpoint);
        if (localEndpointState != null) {
            int localGeneration = localEndpointState.getHeartBeatState().getGeneration();
            int remoteGeneration = remoteEndpointState.getHeartBeatState().getGeneration();
            if (remoteGeneration > localGeneration) {
                localEndpointState.updateTimestamp();
                fd.report(endpoint);
                return;
            }
            if (remoteGeneration == localGeneration) {
                int localVersion = this.getMaxEndpointStateVersion(localEndpointState);
                int remoteVersion = remoteEndpointState.getHeartBeatState().getHeartBeatVersion();
                if (remoteVersion > localVersion) {
                    localEndpointState.updateTimestamp();
                    fd.report(endpoint);
                }
            }
        }
    }

    private void markAlive(InetAddress addr, EndpointState localState) {
        if (logger.isTraceEnabled()) {
            logger.trace("marking as alive {}", (Object)addr);
        }
        localState.markAlive();
        localState.updateTimestamp();
        this.liveEndpoints.add(addr);
        this.unreachableEndpoints.remove(addr);
        logger.info("InetAddress {} is now UP", (Object)addr);
        for (IEndpointStateChangeSubscriber subscriber : this.subscribers) {
            subscriber.onAlive(addr, localState);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Notified " + this.subscribers);
        }
    }

    private void markDead(InetAddress addr, EndpointState localState) {
        if (logger.isTraceEnabled()) {
            logger.trace("marking as dead {}", (Object)addr);
        }
        localState.markDead();
        this.liveEndpoints.remove(addr);
        this.unreachableEndpoints.put(addr, System.currentTimeMillis());
        logger.info("InetAddress {} is now dead.", (Object)addr);
        for (IEndpointStateChangeSubscriber subscriber : this.subscribers) {
            subscriber.onDead(addr, localState);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Notified " + this.subscribers);
        }
    }

    private void handleMajorStateChange(InetAddress ep, EndpointState epState) {
        if (epState.getApplicationState(ApplicationState.STATUS) != null && !this.isDeadState(epState.getApplicationState((ApplicationState)ApplicationState.STATUS).value).booleanValue()) {
            if (this.endpointStateMap.get(ep) != null) {
                logger.info("Node {} has restarted, now UP again", (Object)ep);
            } else {
                logger.info("Node {} is now part of the cluster", (Object)ep);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Adding endpoint state for " + ep);
        }
        this.endpointStateMap.put(ep, epState);
        for (IEndpointStateChangeSubscriber subscriber : this.subscribers) {
            subscriber.onRestart(ep, epState);
        }
        if (epState.getApplicationState(ApplicationState.STATUS) != null && !this.isDeadState(epState.getApplicationState((ApplicationState)ApplicationState.STATUS).value).booleanValue()) {
            this.markAlive(ep, epState);
        } else {
            logger.debug("Not marking " + ep + " alive due to dead state");
            epState.markDead();
            epState.setHasToken(true);
        }
        for (IEndpointStateChangeSubscriber subscriber : this.subscribers) {
            subscriber.onJoin(ep, epState);
        }
    }

    private Boolean isDeadState(String value) {
        String[] pieces = value.split(VersionedValue.DELIMITER_STR, -1);
        assert (pieces.length > 0);
        String state = pieces[0];
        for (String deadstate : DEAD_STATES) {
            if (!state.equals(deadstate)) continue;
            return true;
        }
        return false;
    }

    void applyStateLocally(Map<InetAddress, EndpointState> epStateMap) {
        for (Map.Entry<InetAddress, EndpointState> entry : epStateMap.entrySet()) {
            InetAddress ep = entry.getKey();
            if (ep.equals(FBUtilities.getLocalAddress())) continue;
            if (this.justRemovedEndpoints.containsKey(ep)) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace("Ignoring gossip for " + ep + " because it is quarantined");
                continue;
            }
            EndpointState localEpStatePtr = this.endpointStateMap.get(ep);
            EndpointState remoteState = entry.getValue();
            if (localEpStatePtr != null) {
                int localGeneration = localEpStatePtr.getHeartBeatState().getGeneration();
                int remoteGeneration = remoteState.getHeartBeatState().getGeneration();
                if (logger.isTraceEnabled()) {
                    logger.trace(ep + "local generation " + localGeneration + ", remote generation " + remoteGeneration);
                }
                if (remoteGeneration > localGeneration) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Updating heartbeat state generation to " + remoteGeneration + " from " + localGeneration + " for " + ep);
                    }
                    this.handleMajorStateChange(ep, remoteState);
                    continue;
                }
                if (remoteGeneration == localGeneration) {
                    int localMaxVersion = this.getMaxEndpointStateVersion(localEpStatePtr);
                    int remoteMaxVersion = this.getMaxEndpointStateVersion(remoteState);
                    if (remoteMaxVersion > localMaxVersion) {
                        this.applyNewStates(ep, localEpStatePtr, remoteState);
                    } else if (logger.isTraceEnabled()) {
                        logger.trace("Ignoring remote version " + remoteMaxVersion + " <= " + localMaxVersion + " for " + ep);
                    }
                    if (localEpStatePtr.isAlive()) continue;
                    this.markAlive(ep, localEpStatePtr);
                    continue;
                }
                if (!logger.isTraceEnabled()) continue;
                logger.trace("Ignoring remote generation " + remoteGeneration + " < " + localGeneration);
                continue;
            }
            this.handleMajorStateChange(ep, remoteState);
        }
    }

    private void applyNewStates(InetAddress addr, EndpointState localState, EndpointState remoteState) {
        int oldVersion = localState.getHeartBeatState().getHeartBeatVersion();
        localState.setHeartBeatState(remoteState.getHeartBeatState());
        if (logger.isTraceEnabled()) {
            logger.trace("Updating heartbeat state version to " + localState.getHeartBeatState().getHeartBeatVersion() + " from " + oldVersion + " for " + addr + " ...");
        }
        for (Map.Entry<ApplicationState, VersionedValue> remoteEntry : remoteState.getApplicationStateMap().entrySet()) {
            ApplicationState remoteKey = remoteEntry.getKey();
            VersionedValue remoteValue = remoteEntry.getValue();
            assert (remoteState.getHeartBeatState().getGeneration() == localState.getHeartBeatState().getGeneration());
            localState.addApplicationState(remoteKey, remoteValue);
            this.doNotifications(addr, remoteKey, remoteValue);
        }
    }

    private void doNotifications(InetAddress addr, ApplicationState state, VersionedValue value) {
        for (IEndpointStateChangeSubscriber subscriber : this.subscribers) {
            subscriber.onChange(addr, state, value);
        }
    }

    private void requestAll(GossipDigest gDigest, List<GossipDigest> deltaGossipDigestList, int remoteGeneration) {
        deltaGossipDigestList.add(new GossipDigest(gDigest.getEndpoint(), remoteGeneration, 0));
        if (logger.isTraceEnabled()) {
            logger.trace("requestAll for " + gDigest.getEndpoint());
        }
    }

    private void sendAll(GossipDigest gDigest, Map<InetAddress, EndpointState> deltaEpStateMap, int maxRemoteVersion) {
        EndpointState localEpStatePtr = this.getStateForVersionBiggerThan(gDigest.getEndpoint(), maxRemoteVersion);
        if (localEpStatePtr != null) {
            deltaEpStateMap.put(gDigest.getEndpoint(), localEpStatePtr);
        }
    }

    void examineGossiper(List<GossipDigest> gDigestList, List<GossipDigest> deltaGossipDigestList, Map<InetAddress, EndpointState> deltaEpStateMap) {
        for (GossipDigest gDigest : gDigestList) {
            int remoteGeneration = gDigest.getGeneration();
            int maxRemoteVersion = gDigest.getMaxVersion();
            EndpointState epStatePtr = this.endpointStateMap.get(gDigest.getEndpoint());
            if (epStatePtr != null) {
                int localGeneration = epStatePtr.getHeartBeatState().getGeneration();
                int maxLocalVersion = this.getMaxEndpointStateVersion(epStatePtr);
                if (remoteGeneration == localGeneration && maxRemoteVersion == maxLocalVersion) continue;
                if (remoteGeneration > localGeneration) {
                    this.requestAll(gDigest, deltaGossipDigestList, remoteGeneration);
                    continue;
                }
                if (remoteGeneration < localGeneration) {
                    this.sendAll(gDigest, deltaEpStateMap, 0);
                    continue;
                }
                if (remoteGeneration != localGeneration) continue;
                if (maxRemoteVersion > maxLocalVersion) {
                    deltaGossipDigestList.add(new GossipDigest(gDigest.getEndpoint(), remoteGeneration, maxLocalVersion));
                    continue;
                }
                if (maxRemoteVersion >= maxLocalVersion) continue;
                this.sendAll(gDigest, deltaEpStateMap, maxRemoteVersion);
                continue;
            }
            this.requestAll(gDigest, deltaGossipDigestList, remoteGeneration);
        }
    }

    public void start(int generationNbr) {
        Set<InetAddress> seedHosts = DatabaseDescriptor.getSeeds();
        for (InetAddress seed : seedHosts) {
            if (seed.equals(FBUtilities.getLocalAddress())) continue;
            this.seeds.add(seed);
        }
        this.maybeInitializeLocalState(generationNbr);
        EndpointState localState = this.endpointStateMap.get(FBUtilities.getLocalAddress());
        DatabaseDescriptor.getEndpointSnitch().gossiperStarting();
        if (logger.isTraceEnabled()) {
            logger.trace("gossip started with generation " + localState.getHeartBeatState().getGeneration());
        }
        this.scheduledGossipTask = executor.scheduleWithFixedDelay(new GossipTask(), 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    public void maybeInitializeLocalState(int generationNbr) {
        EndpointState localState = this.endpointStateMap.get(FBUtilities.getLocalAddress());
        if (localState == null) {
            HeartBeatState hbState = new HeartBeatState(generationNbr);
            localState = new EndpointState(hbState);
            localState.markAlive();
            this.endpointStateMap.put(FBUtilities.getLocalAddress(), localState);
        }
    }

    public void addSavedEndpoint(InetAddress ep) {
        EndpointState epState = new EndpointState(new HeartBeatState(0));
        epState.markDead();
        epState.setHasToken(true);
        this.endpointStateMap.put(ep, epState);
        this.unreachableEndpoints.put(ep, System.currentTimeMillis());
        if (logger.isTraceEnabled()) {
            logger.trace("Adding saved endpoint " + ep + " " + epState.getHeartBeatState().getGeneration());
        }
    }

    public void addLocalApplicationState(ApplicationState state, VersionedValue value) {
        EndpointState epState = this.endpointStateMap.get(FBUtilities.getLocalAddress());
        assert (epState != null);
        epState.addApplicationState(state, value);
        this.doNotifications(FBUtilities.getLocalAddress(), state, value);
    }

    public void stop() {
        this.scheduledGossipTask.cancel(false);
    }

    public boolean isEnabled() {
        return !this.scheduledGossipTask.isCancelled();
    }

    public void initializeNodeUnsafe(InetAddress addr, int generationNbr) {
        EndpointState localState = this.endpointStateMap.get(addr);
        if (localState == null) {
            HeartBeatState hbState = new HeartBeatState(generationNbr);
            localState = new EndpointState(hbState);
            localState.markAlive();
            this.endpointStateMap.put(addr, localState);
        }
    }

    private class GossipTask
    implements Runnable {
        private GossipTask() {
        }

        @Override
        public void run() {
            try {
                MessagingService.instance().waitUntilListening();
                Gossiper.this.endpointStateMap.get(FBUtilities.getLocalAddress()).getHeartBeatState().updateHeartBeat();
                if (logger.isTraceEnabled()) {
                    logger.trace("My heartbeat is now " + Gossiper.this.endpointStateMap.get(FBUtilities.getLocalAddress()).getHeartBeatState().getHeartBeatVersion());
                }
                final ArrayList gDigests = new ArrayList();
                instance.makeRandomGossipDigest(gDigests);
                if (gDigests.size() > 0) {
                    MessageProducer prod = new MessageProducer(){

                        @Override
                        public Message getMessage(Integer version) throws IOException {
                            return Gossiper.this.makeGossipDigestSynMessage(gDigests, version);
                        }
                    };
                    boolean gossipedToSeed = Gossiper.this.doGossipToLiveMember(prod);
                    Gossiper.this.doGossipToUnreachableMember(prod);
                    if (!gossipedToSeed || Gossiper.this.liveEndpoints.size() < Gossiper.this.seeds.size()) {
                        Gossiper.this.doGossipToSeed(prod);
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("Performing status check ...");
                    }
                    Gossiper.this.doStatusCheck();
                }
            }
            catch (Exception e) {
                logger.error("Gossip error", (Throwable)e);
            }
        }
    }
}

