/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.CounterColumn;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletedColumn;
import org.apache.cassandra.db.ExpiringColumn;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.KeyIterator;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableScanner;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;

public class SSTableExport {
    private static ObjectMapper jsonMapper = new ObjectMapper();
    private static final String KEY_OPTION = "k";
    private static final String EXCLUDEKEY_OPTION = "x";
    private static final String ENUMERATEKEYS_OPTION = "e";
    private static Options options = new Options();
    private static CommandLine cmd;

    private static void writeKey(PrintStream out, String value) {
        SSTableExport.writeJSON(out, value);
        out.print(": ");
    }

    private static void serializeColumns(Iterator<IColumn> columns, PrintStream out, AbstractType comparator, CFMetaData cfMetaData) {
        while (columns.hasNext()) {
            SSTableExport.writeJSON(out, SSTableExport.serializeColumn(columns.next(), comparator, cfMetaData));
            if (!columns.hasNext()) continue;
            out.print(", ");
        }
    }

    private static List<Object> serializeColumn(IColumn column, AbstractType comparator, CFMetaData cfMetaData) {
        ArrayList<Object> serializedColumn = new ArrayList<Object>();
        ByteBuffer name = ByteBufferUtil.clone(column.name());
        ByteBuffer value = ByteBufferUtil.clone(column.value());
        AbstractType validator = cfMetaData.getValueValidator(name);
        serializedColumn.add(comparator.getString(name));
        serializedColumn.add(validator.getString(value));
        serializedColumn.add(column.timestamp());
        if (column instanceof DeletedColumn) {
            serializedColumn.add("d");
        } else if (column instanceof ExpiringColumn) {
            serializedColumn.add(ENUMERATEKEYS_OPTION);
            serializedColumn.add(((ExpiringColumn)column).getTimeToLive());
            serializedColumn.add(column.getLocalDeletionTime());
        } else if (column instanceof CounterColumn) {
            serializedColumn.add("c");
            serializedColumn.add(((CounterColumn)column).timestampOfLastDelete());
        }
        return serializedColumn;
    }

    private static void serializeRow(SSTableIdentityIterator row, DecoratedKey key, PrintStream out) {
        ColumnFamily columnFamily = row.getColumnFamily();
        boolean isSuperCF = columnFamily.isSuper();
        CFMetaData cfMetaData = columnFamily.metadata();
        AbstractType comparator = columnFamily.getComparator();
        SSTableExport.writeKey(out, ByteBufferUtil.bytesToHex(key.key));
        out.print(isSuperCF ? "{" : "[");
        if (isSuperCF) {
            while (row.hasNext()) {
                IColumn column = row.next();
                SSTableExport.writeKey(out, comparator.getString(column.name()));
                out.print("{");
                SSTableExport.writeKey(out, "deletedAt");
                out.print(column.getMarkedForDeleteAt());
                out.print(", ");
                SSTableExport.writeKey(out, "subColumns");
                out.print("[");
                SSTableExport.serializeColumns(column.getSubColumns().iterator(), out, columnFamily.getSubComparator(), cfMetaData);
                out.print("]");
                out.print("}");
                if (!row.hasNext()) continue;
                out.print(", ");
            }
        } else {
            SSTableExport.serializeColumns(row, out, comparator, cfMetaData);
        }
        out.print(isSuperCF ? "}" : "]");
    }

    public static void enumeratekeys(String ssTableFile, PrintStream outs) throws IOException {
        Descriptor desc = Descriptor.fromFilename(ssTableFile);
        KeyIterator iter = new KeyIterator(desc);
        DecoratedKey lastKey = null;
        while (iter.hasNext()) {
            DecoratedKey key = (DecoratedKey)iter.next();
            if (lastKey != null && lastKey.compareTo(key) > 0) {
                throw new IOException("Key out of order! " + lastKey + " > " + key);
            }
            lastKey = key;
            outs.println(ByteBufferUtil.bytesToHex(key.key));
        }
        iter.close();
        outs.flush();
    }

    public static void export(String ssTableFile, PrintStream outs, Collection<String> toExport, String[] excludes) throws IOException {
        SSTableReader reader = SSTableReader.open(Descriptor.fromFilename(ssTableFile));
        SSTableScanner scanner = reader.getDirectScanner(65535);
        IPartitioner partitioner = StorageService.getPartitioner();
        if (excludes != null) {
            toExport.removeAll(Arrays.asList(excludes));
        }
        outs.println("{");
        int i = 0;
        DecoratedKey lastKey = null;
        for (String key : toExport) {
            SSTableIdentityIterator row;
            DecoratedKey decoratedKey = partitioner.decorateKey(ByteBufferUtil.hexToBytes(key));
            if (lastKey != null && lastKey.compareTo(decoratedKey) > 0) {
                throw new IOException("Key out of order! " + lastKey + " > " + decoratedKey);
            }
            lastKey = decoratedKey;
            scanner.seekTo(decoratedKey);
            if (!scanner.hasNext() || !(row = (SSTableIdentityIterator)scanner.next()).getKey().equals(decoratedKey)) continue;
            SSTableExport.serializeRow(row, decoratedKey, outs);
            if (i != 0) {
                outs.println(",");
            }
            ++i;
        }
        outs.println("\n}");
        outs.flush();
        scanner.close();
    }

    static void export(SSTableReader reader, PrintStream outs, String[] excludes) throws IOException {
        HashSet<Object> excludeSet = new HashSet();
        if (excludes != null) {
            excludeSet = new HashSet<String>(Arrays.asList(excludes));
        }
        SSTableScanner scanner = reader.getDirectScanner(65535);
        outs.println("{");
        int i = 0;
        while (scanner.hasNext()) {
            SSTableIdentityIterator row = (SSTableIdentityIterator)scanner.next();
            String currentKey = ByteBufferUtil.bytesToHex(row.getKey().key);
            if (excludeSet.contains(currentKey)) continue;
            if (i != 0) {
                outs.println(",");
            }
            SSTableExport.serializeRow(row, row.getKey(), outs);
            ++i;
        }
        outs.println("\n}");
        outs.flush();
        scanner.close();
    }

    public static void export(String ssTableFile, PrintStream outs, String[] excludes) throws IOException {
        CFMetaData metadata;
        Descriptor descriptor = Descriptor.fromFilename(ssTableFile);
        if (descriptor.cfname.contains(".")) {
            int i = descriptor.cfname.indexOf(".");
            String parentName = descriptor.cfname.substring(0, i);
            CFMetaData parent = DatabaseDescriptor.getCFMetaData(descriptor.ksname, parentName);
            ColumnDefinition def = parent.getColumnDefinitionForIndex(descriptor.cfname.substring(i + 1));
            metadata = CFMetaData.newIndexMetadata(parent, def, ColumnFamilyStore.indexComparator());
        } else {
            metadata = DatabaseDescriptor.getCFMetaData(descriptor.ksname, descriptor.cfname);
        }
        SSTableExport.export(SSTableReader.open(descriptor, metadata), outs, excludes);
    }

    public static void export(String ssTableFile, String[] excludes) throws IOException {
        SSTableExport.export(ssTableFile, System.out, excludes);
    }

    public static void main(String[] args) throws IOException, ConfigurationException {
        String usage = String.format("Usage: %s <sstable> [-k key [-k key [...]] -x key [-x key [...]]]%n", SSTableExport.class.getName());
        PosixParser parser = new PosixParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e1) {
            System.err.println(e1.getMessage());
            System.err.println(usage);
            System.exit(1);
        }
        if (cmd.getArgs().length != 1) {
            System.err.println("You must supply exactly one sstable");
            System.err.println(usage);
            System.exit(1);
        }
        String[] keys = cmd.getOptionValues(KEY_OPTION);
        String[] excludes = cmd.getOptionValues(EXCLUDEKEY_OPTION);
        String ssTableFileName = new File(cmd.getArgs()[0]).getAbsolutePath();
        DatabaseDescriptor.loadSchemas();
        if (DatabaseDescriptor.getNonSystemTables().size() < 1) {
            String msg = "no non-system tables are defined";
            System.err.println(msg);
            throw new ConfigurationException(msg);
        }
        if (cmd.hasOption(ENUMERATEKEYS_OPTION)) {
            SSTableExport.enumeratekeys(ssTableFileName, System.out);
        } else if (keys != null && keys.length > 0) {
            SSTableExport.export(ssTableFileName, System.out, Arrays.asList(keys), excludes);
        } else {
            SSTableExport.export(ssTableFileName, excludes);
        }
        System.exit(0);
    }

    private static void writeJSON(PrintStream out, Object value) {
        try {
            jsonMapper.writeValue((OutputStream)out, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    static {
        Option optKey = new Option(KEY_OPTION, true, "Row key");
        optKey.setArgs(500);
        options.addOption(optKey);
        Option excludeKey = new Option(EXCLUDEKEY_OPTION, true, "Excluded row key");
        excludeKey.setArgs(500);
        options.addOption(excludeKey);
        Option optEnumerate = new Option(ENUMERATEKEYS_OPTION, false, "enumerate keys only");
        options.addOption(optEnumerate);
        jsonMapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
    }
}

