/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import com.ning.compress.lzf.LZFOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.io.compress.CompressedRandomAccessReader;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.streaming.StreamHeader;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.Throttle;
import org.apache.cassandra.utils.WrappedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStreamTask
extends WrappedRunnable {
    private static Logger logger = LoggerFactory.getLogger(FileStreamTask.class);
    public static final int CHUNK_SIZE = 65536;
    public static final int MAX_CONNECT_ATTEMPTS = 8;
    protected final StreamHeader header;
    protected final InetAddress to;
    private Socket socket;
    private OutputStream output;
    private final byte[] transferBuffer = new byte[65536];
    private final Throttle throttle;

    public FileStreamTask(StreamHeader header, InetAddress to) {
        this.header = header;
        this.to = to;
        this.throttle = new Throttle(this.toString(), new Throttle.ThroughputFunction(){

            @Override
            public int targetThroughput() {
                if (DatabaseDescriptor.getStreamThroughputOutboundMegabitsPerSec() < 1) {
                    return 0;
                }
                int totalBytesPerMS = DatabaseDescriptor.getStreamThroughputOutboundMegabitsPerSec() * 1024 * 1024 / 8 / 1000;
                return totalBytesPerMS / Math.max(1, MessagingService.instance().getActiveStreamsOutbound());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runMayThrow() throws IOException {
        try {
            this.connectAttempt();
            this.stream();
        }
        finally {
            block9: {
                try {
                    this.close();
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) break block9;
                    logger.debug("error closing socket", (Throwable)e);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Done streaming " + this.header.file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stream() throws IOException {
        ByteBuffer HeaderBuffer = MessagingService.instance().constructStreamHeader(this.header, false, Gossiper.instance.getVersion(this.to));
        this.output.write(ByteBufferUtil.getArray(HeaderBuffer));
        if (this.header.file == null) {
            return;
        }
        RandomAccessReader file = this.header.file.sstable.compression ? CompressedRandomAccessReader.open(this.header.file.getFilename(), this.header.file.sstable.getCompressionMetadata(), true) : RandomAccessReader.open(new File(this.header.file.getFilename()), true);
        this.output = new LZFOutputStream(this.output);
        try {
            for (Pair<Long, Long> section : this.header.file.sections) {
                file.seek((Long)section.left);
                long length = (Long)section.right - (Long)section.left;
                long bytesTransferred = 0L;
                while (bytesTransferred < length) {
                    long lastWrite = this.write(file, length, bytesTransferred);
                    bytesTransferred += lastWrite;
                    this.header.file.progress += lastWrite;
                }
                this.output.flush();
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Bytes transferred " + bytesTransferred + "/" + this.header.file.size);
            }
        }
        finally {
            FileUtils.closeQuietly(file);
        }
    }

    protected long write(RandomAccessReader reader, long length, long bytesTransferred) throws IOException {
        int toTransfer = (int)Math.min(65536L, length - bytesTransferred);
        reader.readFully(this.transferBuffer, 0, toTransfer);
        this.output.write(this.transferBuffer, 0, toTransfer);
        this.throttle.throttleDelta(toTransfer);
        return toTransfer;
    }

    private void connectAttempt() throws IOException {
        int attempts = 0;
        while (true) {
            try {
                this.socket = MessagingService.instance().getConnectionPool(this.to).newSocket();
                this.socket.setSoTimeout(DatabaseDescriptor.getStreamingSocketTimeout());
                this.output = this.socket.getOutputStream();
                break;
            }
            catch (IOException e) {
                if (++attempts >= 8) {
                    throw e;
                }
                long waitms = DatabaseDescriptor.getRpcTimeout() * (long)Math.pow(2.0, attempts);
                logger.warn("Failed attempt " + attempts + " to connect to " + this.to + " to stream " + this.header.file + ". Retrying in " + waitms + " ms. (" + e + ")");
                try {
                    Thread.sleep(waitms);
                }
                catch (InterruptedException wtf) {
                    throw new RuntimeException(wtf);
                }
            }
        }
    }

    protected void close() throws IOException {
        this.output.close();
    }

    public String toString() {
        return String.format("FileStreamTask(session=%s, to=%s)", this.header.sessionId, this.to);
    }
}

