/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Predicate;
import com.google.common.collect.AbstractIterator;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.columniterator.IColumnIterator;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableScanner;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.MergeIterator;

public class RowIteratorFactory {
    private static final int RANGE_FILE_BUFFER_SIZE = 262144;
    private static final Comparator<IColumnIterator> COMPARE_BY_KEY = new Comparator<IColumnIterator>(){

        @Override
        public int compare(IColumnIterator o1, IColumnIterator o2) {
            return DecoratedKey.comparator.compare(o1.getKey(), o2.getKey());
        }
    };

    public static CloseableIterator<Row> getIterator(Iterable<Memtable> memtables, Collection<SSTableReader> sstables, final DecoratedKey startWith, final DecoratedKey stopAt, final QueryFilter filter, final AbstractType comparator, final ColumnFamilyStore cfs) {
        ArrayList<CloseableIterator<IColumnIterator>> iterators = new ArrayList<CloseableIterator<IColumnIterator>>();
        Predicate<IColumnIterator> p = new Predicate<IColumnIterator>(){

            public boolean apply(IColumnIterator row) {
                return startWith.compareTo(row.getKey()) <= 0 && (stopAt.isEmpty() || row.getKey().compareTo(stopAt) <= 0);
            }
        };
        for (Memtable memtable : memtables) {
            iterators.add(new ConvertToColumnIterator(filter, comparator, p, memtable.getEntryIterator(startWith)));
        }
        for (SSTableReader sstable : sstables) {
            SSTableScanner scanner = sstable.getScanner(filter);
            scanner.seekTo(startWith);
            assert (scanner instanceof Closeable);
            iterators.add(scanner);
        }
        Memtable firstMemtable = memtables.iterator().next();
        return MergeIterator.get(iterators, COMPARE_BY_KEY, new MergeIterator.Reducer<IColumnIterator, Row>(){
            private final int gcBefore;
            private final List<IColumnIterator> colIters;
            private DecoratedKey key;
            private ColumnFamily returnCF;
            {
                this.gcBefore = (int)(System.currentTimeMillis() / 1000L) - cfs.metadata.getGcGraceSeconds();
                this.colIters = new ArrayList<IColumnIterator>();
            }

            @Override
            protected void onKeyChange() {
                this.returnCF = ColumnFamily.create(cfs.metadata);
            }

            @Override
            public void reduce(IColumnIterator current) {
                this.colIters.add(current);
                this.key = current.getKey();
                this.returnCF.delete(current.getColumnFamily());
            }

            @Override
            protected Row getReduced() {
                ColumnFamily cached = cfs.getRawCachedRow(this.key);
                if (cached == null) {
                    filter.collateColumns(this.returnCF, this.colIters, comparator, this.gcBefore);
                } else {
                    QueryFilter keyFilter = new QueryFilter(this.key, filter.path, filter.filter);
                    this.returnCF = cfs.filterColumnFamily(cached, keyFilter, this.gcBefore);
                }
                Row rv = new Row(this.key, this.returnCF);
                this.colIters.clear();
                this.key = null;
                return rv;
            }
        });
    }

    private static class ConvertToColumnIterator
    extends AbstractIterator<IColumnIterator>
    implements CloseableIterator<IColumnIterator> {
        private final QueryFilter filter;
        private final AbstractType comparator;
        private final Predicate<IColumnIterator> pred;
        private final Iterator<Map.Entry<DecoratedKey, ColumnFamily>> iter;

        public ConvertToColumnIterator(QueryFilter filter, AbstractType comparator, Predicate<IColumnIterator> pred, Iterator<Map.Entry<DecoratedKey, ColumnFamily>> iter) {
            this.filter = filter;
            this.comparator = comparator;
            this.pred = pred;
            this.iter = iter;
        }

        public IColumnIterator computeNext() {
            while (this.iter.hasNext()) {
                Map.Entry<DecoratedKey, ColumnFamily> entry = this.iter.next();
                IColumnIterator ici = this.filter.getMemtableColumnIterator(entry.getValue(), entry.getKey(), this.comparator);
                if (!this.pred.apply((Object)ici)) continue;
                return ici;
            }
            return (IColumnIterator)this.endOfData();
        }

        @Override
        public void close() {
        }
    }
}

