/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.IOException;
import org.apache.cassandra.cache.FreeableMemory;
import org.apache.cassandra.io.util.AbstractDataInput;

public class MemoryInputStream
extends AbstractDataInput {
    private final FreeableMemory mem;
    private int position = 0;

    public MemoryInputStream(FreeableMemory mem) {
        this.mem = mem;
    }

    @Override
    public int read() throws IOException {
        return this.mem.getValidByte(this.position++) & 0xFF;
    }

    @Override
    protected void seekInternal(int pos) {
        this.position = pos;
    }

    @Override
    protected int getPosition() {
        return this.position;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.seekInternal(this.getPosition() + n);
        return this.position;
    }

    @Override
    public void close() {
    }
}

