/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.auth.Resources;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.thrift.AuthenticationException;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientState {
    private static Logger logger = LoggerFactory.getLogger(ClientState.class);
    private AuthenticatedUser user;
    private String keyspace;
    private final List<Object> resource = new ArrayList<Object>();
    private long clock;

    public ClientState() {
        this.reset();
    }

    public String getRawKeyspace() {
        return this.keyspace;
    }

    public String getKeyspace() throws InvalidRequestException {
        if (this.keyspace == null) {
            throw new InvalidRequestException("no keyspace has been specified");
        }
        return this.keyspace;
    }

    public void setKeyspace(String ks) {
        this.keyspace = ks;
    }

    public String getSchedulingValue() {
        switch (DatabaseDescriptor.getRequestSchedulerId()) {
            case keyspace: {
                return this.keyspace;
            }
        }
        return "default";
    }

    public void login(Map<? extends CharSequence, ? extends CharSequence> credentials) throws AuthenticationException {
        AuthenticatedUser user = DatabaseDescriptor.getAuthenticator().authenticate(credentials);
        if (logger.isDebugEnabled()) {
            logger.debug("logged in: {}", (Object)user);
        }
        this.user = user;
    }

    public void logout() {
        if (logger.isDebugEnabled()) {
            logger.debug("logged out: {}", (Object)this.user);
        }
        this.reset();
    }

    private void resourceClear() {
        this.resource.clear();
        this.resource.add("cassandra");
        this.resource.add("keyspaces");
    }

    public void reset() {
        this.user = DatabaseDescriptor.getAuthenticator().defaultUser();
        this.keyspace = null;
        this.resourceClear();
    }

    public void hasKeyspaceSchemaAccess(Permission perm) throws InvalidRequestException {
        this.validateLogin();
        this.resourceClear();
        EnumSet<Permission> perms = DatabaseDescriptor.getAuthority().authorize(this.user, this.resource);
        ClientState.hasAccess(this.user, perms, perm, this.resource);
    }

    public void hasColumnFamilySchemaAccess(Permission perm) throws InvalidRequestException {
        this.validateLogin();
        this.validateKeyspace();
        if (this.keyspace.equalsIgnoreCase("system") && perm == Permission.WRITE) {
            throw new InvalidRequestException("system keyspace is not user-modifiable");
        }
        this.resourceClear();
        this.resource.add(this.keyspace);
        EnumSet<Permission> perms = DatabaseDescriptor.getAuthority().authorize(this.user, this.resource);
        ClientState.hasAccess(this.user, perms, perm, this.resource);
    }

    public void hasColumnFamilyAccess(String columnFamily, Permission perm) throws InvalidRequestException {
        this.hasColumnFamilyAccess(this.keyspace, columnFamily, perm);
    }

    public void hasColumnFamilyAccess(String keyspace, String columnFamily, Permission perm) throws InvalidRequestException {
        this.validateLogin();
        this.validateKeyspace();
        this.resourceClear();
        this.resource.add(keyspace);
        this.resource.add(columnFamily);
        EnumSet<Permission> perms = DatabaseDescriptor.getAuthority().authorize(this.user, this.resource);
        ClientState.hasAccess(this.user, perms, perm, this.resource);
    }

    private void validateLogin() throws InvalidRequestException {
        if (this.user == null) {
            throw new InvalidRequestException("You have not logged in");
        }
    }

    private void validateKeyspace() throws InvalidRequestException {
        if (this.keyspace == null) {
            throw new InvalidRequestException("You have not set a keyspace for this session");
        }
    }

    private static void hasAccess(AuthenticatedUser user, Set<Permission> perms, Permission perm, List<Object> resource) throws InvalidRequestException {
        if (perms.contains((Object)perm)) {
            return;
        }
        throw new InvalidRequestException(String.format("%s does not have permission %s for %s", new Object[]{user, perm, Resources.toString(resource)}));
    }

    public long getTimestamp() {
        long current = System.currentTimeMillis() * 1000L;
        this.clock = this.clock >= current ? this.clock + 1L : current;
        return this.clock;
    }
}

