/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql.jdbc.JdbcFloat;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;

public class FloatType
extends AbstractType<Float> {
    public static final FloatType instance = new FloatType();

    FloatType() {
    }

    @Override
    public Float compose(ByteBuffer bytes) {
        return JdbcFloat.instance.compose(bytes);
    }

    @Override
    public ByteBuffer decompose(Float value) {
        return JdbcFloat.instance.decompose(value);
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        if (o1.remaining() == 0) {
            return o2.remaining() == 0 ? 0 : -1;
        }
        if (o2.remaining() == 0) {
            return 1;
        }
        return this.compose(o1).compareTo(this.compose(o2));
    }

    @Override
    public String getString(ByteBuffer bytes) {
        try {
            return JdbcFloat.instance.getString(bytes);
        }
        catch (org.apache.cassandra.cql.jdbc.MarshalException e) {
            throw new MarshalException(e.getMessage());
        }
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        try {
            float f = Float.parseFloat(source);
            return ByteBufferUtil.bytes(f);
        }
        catch (NumberFormatException e1) {
            throw new MarshalException(String.format("unable to coerce '%s' to a float", source), e1);
        }
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        if (bytes.remaining() != 4 && bytes.remaining() != 0) {
            throw new MarshalException(String.format("Expected 4 or 0 byte value for a float (%d)", bytes.remaining()));
        }
    }
}

