/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import org.apache.cassandra.gms.HeartBeatStateSerializer;
import org.apache.cassandra.gms.VersionGenerator;
import org.apache.cassandra.io.IVersionedSerializer;

class HeartBeatState {
    private static IVersionedSerializer<HeartBeatState> serializer = new HeartBeatStateSerializer();
    private int generation;
    private int version;

    HeartBeatState(int gen) {
        this(gen, 0);
    }

    HeartBeatState(int gen, int ver) {
        this.generation = gen;
        this.version = ver;
    }

    public static IVersionedSerializer<HeartBeatState> serializer() {
        return serializer;
    }

    int getGeneration() {
        return this.generation;
    }

    void updateHeartBeat() {
        this.version = VersionGenerator.getNextVersion();
    }

    int getHeartBeatVersion() {
        return this.version;
    }

    void forceNewerGenerationUnsafe() {
        ++this.generation;
    }
}

