/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.cql3.TermType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.thrift.InvalidRequestException;

public class Term {
    private final String text;
    private final TermType type;
    public final int bindIndex;
    public final boolean isToken;

    private Term(String text, TermType type, int bindIndex, boolean isToken) {
        this.text = text == null ? "" : text;
        this.type = type;
        this.bindIndex = bindIndex;
        this.isToken = isToken;
    }

    public Term(String text, TermType type) {
        this(text, type, -1, false);
    }

    public Term(String text, int type) {
        this(text, TermType.forInt(type));
    }

    public Term(long value, TermType type) {
        this(String.valueOf(value), type);
    }

    public Term(String text, int type, int index) {
        this(text, TermType.forInt(type), index, false);
    }

    public static Term tokenOf(Term t) {
        return new Term(t.text, t.type, t.bindIndex, true);
    }

    public String getText() {
        return this.isToken ? "token(" + this.text + ")" : this.text;
    }

    public ByteBuffer getByteBuffer(AbstractType<?> validator, List<ByteBuffer> variables) throws InvalidRequestException {
        try {
            if (!this.isBindMarker()) {
                return validator.fromString(this.text);
            }
            if (this.bindIndex == -1) {
                throw new AssertionError((Object)"a marker Term was encountered with no index value");
            }
            ByteBuffer value = variables.get(this.bindIndex);
            validator.validate(value);
            return value;
        }
        catch (MarshalException e) {
            throw new InvalidRequestException(e.getMessage());
        }
    }

    public Token getAsToken(AbstractType<?> validator, List<ByteBuffer> variables, IPartitioner<?> p) throws InvalidRequestException {
        if (!this.isToken && this.type != TermType.STRING) {
            throw new InvalidRequestException("Invalid value for token (use a string literal of the token value or the token() function)");
        }
        try {
            if (this.isToken) {
                ByteBuffer value = this.getByteBuffer(validator, variables);
                return p.getToken(value);
            }
            p.getTokenFactory().validate(this.text);
            return p.getTokenFactory().fromString(this.text);
        }
        catch (ConfigurationException e) {
            throw new InvalidRequestException(e.getMessage());
        }
    }

    public TermType getType() {
        return this.type;
    }

    public boolean isBindMarker() {
        return this.type == TermType.QMARK;
    }

    public String toString() {
        return String.format("Term(%s, type=%s%s)", new Object[]{this.getText(), this.type, this.isToken ? ", isToken" : ""});
    }

    public int hashCode() {
        int prime = 31;
        int result = 1 + (this.isToken ? 1 : 0);
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Term other = (Term)obj;
        if (this.type == TermType.QMARK) {
            return false;
        }
        if (this.text == null ? other.text != null : !this.text.equals(other.text)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return this.isToken == other.isToken;
    }
}

