/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Memtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeteredFlusher
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(MeteredFlusher.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Memtable activelyMeasuring = Memtable.activelyMeasuring;
        long flushingBytes = activelyMeasuring == null ? 0L : activelyMeasuring.getLiveSize();
        flushingBytes += this.countFlushingBytes();
        long liveBytes = 0L;
        try {
            long size;
            for (ColumnFamilyStore cfs : ColumnFamilyStore.all()) {
                size = cfs.getTotalMemtableLiveSize();
                int maxInFlight = (int)Math.ceil((double)(2 + DatabaseDescriptor.getFlushWriters() + DatabaseDescriptor.getFlushQueueSize()) / (double)(1 + cfs.indexManager.getIndexedColumns().size()));
                if (size > ((long)DatabaseDescriptor.getTotalMemtableSpaceInMB() * 0x100000L - flushingBytes) / (long)maxInFlight) {
                    logger.info("flushing high-traffic column family {} (estimated {} bytes)", (Object)cfs, (Object)size);
                    cfs.forceFlush();
                    continue;
                }
                liveBytes += size;
            }
            if (flushingBytes + liveBytes <= (long)DatabaseDescriptor.getTotalMemtableSpaceInMB() * 0x100000L) {
                return;
            }
            logger.info("estimated {} bytes used by all memtables pre-flush", (Object)liveBytes);
            ArrayList sorted = new ArrayList();
            Iterables.addAll(sorted, ColumnFamilyStore.all());
            Collections.sort(sorted, new Comparator<ColumnFamilyStore>(){

                @Override
                public int compare(ColumnFamilyStore o1, ColumnFamilyStore o2) {
                    long size2;
                    long size1 = o1.getTotalMemtableLiveSize();
                    if (size1 < (size2 = o2.getTotalMemtableLiveSize())) {
                        return -1;
                    }
                    if (size1 > size2) {
                        return 1;
                    }
                    return 0;
                }
            });
            while (liveBytes + (flushingBytes = this.countFlushingBytes()) > (long)DatabaseDescriptor.getTotalMemtableSpaceInMB() * 0x100000L) {
                ColumnFamilyStore cfs;
                if (sorted.isEmpty()) {
                    break;
                }
                cfs = (ColumnFamilyStore)sorted.remove(sorted.size() - 1);
                size = cfs.getTotalMemtableLiveSize();
                logger.info("flushing {} to free up {} bytes", (Object)cfs, (Object)size);
                liveBytes -= size;
                cfs.forceFlush();
            }
        }
        finally {
            logger.trace("memtable memory usage is {} bytes with {} live", (Object)(liveBytes + flushingBytes), (Object)liveBytes);
        }
    }

    private long countFlushingBytes() {
        long flushingBytes = 0L;
        for (ColumnFamilyStore cfs : ColumnFamilyStore.all()) {
            for (Memtable memtable : cfs.getMemtablesPendingFlush()) {
                flushingBytes += memtable.getLiveSize();
            }
        }
        return flushingBytes;
    }
}

