/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutor;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.commitlog.CommitLogSegment;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.WrappedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitLogArchiver {
    private static final Logger logger = LoggerFactory.getLogger(CommitLogArchiver.class);
    public final Map<String, Future<?>> archivePending;
    public final ExecutorService executor;
    private final String archiveCommand;
    private final String restoreCommand;
    private final String restoreDirectories;
    public final long restorePointInTime;

    public CommitLogArchiver() {
        InputStream stream;
        block7: {
            this.archivePending = new ConcurrentHashMap();
            this.executor = new JMXEnabledThreadPoolExecutor("commitlog_archiver");
            Properties commitlog_commands = new Properties();
            stream = null;
            try {
                stream = this.getClass().getClassLoader().getResourceAsStream("commitlog_archiving.properties");
                if (stream == null) {
                    logger.debug("No commitlog_archiving properties found; archive + pitr will be disabled");
                    this.archiveCommand = null;
                    this.restoreCommand = null;
                    this.restoreDirectories = null;
                    this.restorePointInTime = Long.MAX_VALUE;
                    break block7;
                }
                commitlog_commands.load(stream);
                this.archiveCommand = commitlog_commands.getProperty("archive_command");
                this.restoreCommand = commitlog_commands.getProperty("restore_command");
                this.restoreDirectories = commitlog_commands.getProperty("restore_directories");
                String targetTime = commitlog_commands.getProperty("restore_point_in_time");
                try {
                    this.restorePointInTime = Strings.isNullOrEmpty((String)targetTime) ? Long.MAX_VALUE : new SimpleDateFormat("yyyy:MM:dd HH:mm:ss").parse(targetTime).getTime();
                }
                catch (ParseException e) {
                    throw new RuntimeException("Unable to parse restore target time", e);
                }
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException("Unable to load commitlog_archiving.properties", e);
                }
                catch (Throwable throwable) {
                    FileUtils.closeQuietly(stream);
                    throw throwable;
                }
            }
        }
        FileUtils.closeQuietly(stream);
    }

    public void maybeArchive(final String path, final String name) {
        if (Strings.isNullOrEmpty((String)this.archiveCommand)) {
            return;
        }
        this.archivePending.put(name, this.executor.submit(new WrappedRunnable(){

            @Override
            protected void runMayThrow() throws IOException {
                String command = CommitLogArchiver.this.archiveCommand.replace("%name", name);
                command = command.replace("%path", path);
                CommitLogArchiver.this.exec(command);
            }
        }));
    }

    public boolean maybeWaitForArchiving(String name) {
        Future<?> f = this.archivePending.remove(name);
        if (f == null) {
            return true;
        }
        try {
            f.get();
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                logger.info("Looks like the archiving of file {} failed earlier, cassandra is going to ignore this segment for now.", (Object)name);
                return false;
            }
            throw new RuntimeException(e);
        }
        return true;
    }

    public void maybeRestoreArchive() throws IOException {
        if (Strings.isNullOrEmpty((String)this.restoreDirectories)) {
            return;
        }
        for (String dir : this.restoreDirectories.split(",")) {
            File[] files;
            for (File fromFile : files = new File(dir).listFiles()) {
                File toFile = new File(DatabaseDescriptor.getCommitLogLocation(), "CommitLog-" + CommitLogSegment.getNextId() + ".log");
                String command = this.restoreCommand.replace("%from", fromFile.getPath());
                command = command.replace("%to", toFile.getPath());
                this.exec(command);
            }
        }
    }

    private void exec(String command) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(command.split(" "));
        pb.redirectErrorStream(true);
        FBUtilities.exec(pb);
    }
}

