/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.compress;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.compress.CorruptedBlockException;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressedRandomAccessReader
extends RandomAccessReader {
    private static final Logger logger = LoggerFactory.getLogger(CompressedRandomAccessReader.class);
    private final CompressionMetadata metadata;
    private ByteBuffer compressed;
    private final Checksum checksum = new CRC32();
    private final ByteBuffer checksumBytes = ByteBuffer.wrap(new byte[4]);

    public static RandomAccessReader open(String dataFilePath, CompressionMetadata metadata) throws IOException {
        return CompressedRandomAccessReader.open(dataFilePath, metadata, false);
    }

    public static RandomAccessReader open(String dataFilePath, CompressionMetadata metadata, boolean skipIOCache) throws IOException {
        return new CompressedRandomAccessReader(dataFilePath, metadata, skipIOCache);
    }

    public CompressedRandomAccessReader(String dataFilePath, CompressionMetadata metadata, boolean skipIOCache) throws IOException {
        super(new File(dataFilePath), metadata.chunkLength(), skipIOCache);
        this.metadata = metadata;
        this.compressed = ByteBuffer.wrap(new byte[metadata.compressor().initialCompressedBufferLength(metadata.chunkLength())]);
    }

    @Override
    protected void reBuffer() throws IOException {
        this.decompressChunk(this.metadata.chunkFor(this.current));
    }

    private void decompressChunk(CompressionMetadata.Chunk chunk) throws IOException {
        if (this.channel.position() != chunk.offset) {
            this.channel.position(chunk.offset);
        }
        if (this.compressed.capacity() < chunk.length) {
            this.compressed = ByteBuffer.wrap(new byte[chunk.length]);
        } else {
            this.compressed.clear();
        }
        this.compressed.limit(chunk.length);
        if (this.channel.read(this.compressed) != chunk.length) {
            throw new IOException(String.format("(%s) failed to read %d bytes from offset %d.", this.getPath(), chunk.length, chunk.offset));
        }
        this.compressed.flip();
        this.validBufferBytes = this.metadata.compressor().uncompress(this.compressed.array(), 0, chunk.length, this.buffer, 0);
        if (this.metadata.parameters.getCrcCheckChance() > FBUtilities.threadLocalRandom().nextDouble()) {
            this.checksum.update(this.buffer, 0, this.validBufferBytes);
            if (this.checksum(chunk) != (int)this.checksum.getValue()) {
                throw new CorruptedBlockException(this.getPath(), chunk);
            }
            this.checksum.reset();
        }
        this.bufferOffset = this.current & (long)(~(this.buffer.length - 1));
    }

    private int checksum(CompressionMetadata.Chunk chunk) throws IOException {
        assert (this.channel.position() == chunk.offset + (long)chunk.length);
        this.checksumBytes.clear();
        if (this.channel.read(this.checksumBytes) != this.checksumBytes.capacity()) {
            throw new IOException(String.format("(%s) failed to read checksum of the chunk at %d of length %d.", this.getPath(), chunk.offset, chunk.length));
        }
        return this.checksumBytes.getInt(0);
    }

    @Override
    public long length() throws IOException {
        return this.metadata.dataLength;
    }

    @Override
    public String toString() {
        return String.format("%s - chunk length %d, data length %d.", this.getPath(), this.metadata.chunkLength(), this.metadata.dataLength);
    }
}

