/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.IntervalTree;

import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.utils.IntervalTree.Interval;
import org.apache.cassandra.utils.IntervalTree.IntervalNode;

public class IntervalTree<T> {
    private final IntervalNode head;

    public IntervalTree() {
        this.head = null;
    }

    public IntervalTree(List<Interval> intervals) {
        this.head = new IntervalNode(intervals);
    }

    public Comparable max() {
        return this.head.v_max;
    }

    public Comparable min() {
        return this.head.v_min;
    }

    public List<T> search(Interval<T> searchInterval) {
        ArrayList results = new ArrayList();
        this.searchInternal(this.head, searchInterval, results);
        return results;
    }

    protected void searchInternal(IntervalNode node, Interval<T> searchInterval, List<T> results) {
        if (null == this.head) {
            return;
        }
        if (null == node || node.v_pt == null) {
            return;
        }
        if (searchInterval.contains(node.v_pt)) {
            for (Interval interval : node.intersects_left) {
                results.add(interval.Data);
            }
            this.searchInternal(node.left, searchInterval, results);
            this.searchInternal(node.right, searchInterval, results);
            return;
        }
        if (node.v_pt.compareTo(searchInterval.min) < 0) {
            for (Interval interval : node.intersects_right) {
                if (interval.max.compareTo(searchInterval.min) < 0) break;
                results.add(interval.Data);
            }
            this.searchInternal(node.right, searchInterval, results);
            return;
        }
        if (node.v_pt.compareTo(searchInterval.max) > 0) {
            for (Interval interval : node.intersects_left) {
                if (interval.min.compareTo(searchInterval.max) > 0) break;
                results.add(interval.Data);
            }
            this.searchInternal(node.left, searchInterval, results);
            return;
        }
    }
}

