/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Throttle {
    private static Logger logger = LoggerFactory.getLogger(Throttle.class);
    private final String name;
    private final ThroughputFunction fun;
    private long bytesAtLastDelay;
    private long timeAtLastDelay;
    private int targetBytesPerMS = -1;

    public Throttle(String name, ThroughputFunction fun) {
        this.name = name;
        this.fun = fun;
    }

    public void throttle(long currentBytes) {
        this.throttleDelta(currentBytes - this.bytesAtLastDelay);
    }

    public void throttleDelta(long bytesDelta) {
        int newTargetBytesPerMS = this.fun.targetThroughput();
        if (newTargetBytesPerMS < 1) {
            return;
        }
        if (newTargetBytesPerMS != this.targetBytesPerMS) {
            logger.debug("{} target throughput now {} bytes/ms.", (Object)this, (Object)newTargetBytesPerMS);
            this.targetBytesPerMS = newTargetBytesPerMS;
            this.bytesAtLastDelay += bytesDelta;
            this.timeAtLastDelay = System.currentTimeMillis();
            return;
        }
        long msSinceLast = System.currentTimeMillis() - this.timeAtLastDelay;
        long excessBytes = bytesDelta - msSinceLast * (long)this.targetBytesPerMS;
        long timeToDelay = excessBytes / (long)Math.max(1, this.targetBytesPerMS);
        if (timeToDelay > 0L) {
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("%s actual throughput was %d bytes in %d ms: throttling for %d ms", this, bytesDelta, msSinceLast, timeToDelay));
            }
            try {
                Thread.sleep(timeToDelay);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        }
        this.bytesAtLastDelay += bytesDelta;
        this.timeAtLastDelay = System.currentTimeMillis();
    }

    public String toString() {
        return "Throttle(for=" + this.name + ")";
    }

    public static interface ThroughputFunction {
        public int targetThroughput();
    }
}

