/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index.keys;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.filter.ExtendedFilter;
import org.apache.cassandra.db.filter.IFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.db.index.SecondaryIndexSearcher;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.LocalToken;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.IndexOperator;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeysSearcher
extends SecondaryIndexSearcher {
    private static final Logger logger = LoggerFactory.getLogger(KeysSearcher.class);

    public KeysSearcher(SecondaryIndexManager indexManager, Set<ByteBuffer> columns) {
        super(indexManager, columns);
    }

    private IndexExpression highestSelectivityPredicate(List<IndexExpression> clause) {
        IndexExpression best = null;
        int bestMeanCount = Integer.MAX_VALUE;
        for (IndexExpression expression : clause) {
            int columns;
            SecondaryIndex index;
            if (!this.columns.contains(expression.column_name) || (index = this.indexManager.getIndexForColumn(expression.column_name)) == null || expression.op != IndexOperator.EQ || (columns = index.getIndexCfs().getMeanColumns()) >= bestMeanCount) continue;
            best = expression;
            bestMeanCount = columns;
        }
        return best;
    }

    private String expressionString(IndexExpression expr) {
        return String.format("'%s.%s %s %s'", this.baseCfs.columnFamily, this.baseCfs.getComparator().getString(expr.column_name), expr.op, this.baseCfs.metadata.getColumn_metadata().get(expr.column_name).getValidator().getString(expr.value));
    }

    @Override
    public boolean isIndexing(List<IndexExpression> clause) {
        return this.highestSelectivityPredicate(clause) != null;
    }

    @Override
    public List<Row> search(List<IndexExpression> clause, AbstractBounds<RowPosition> range, int maxResults, IFilter dataFilter, boolean maxIsColumns) {
        assert (clause != null && !clause.isEmpty());
        ExtendedFilter filter = ExtendedFilter.create(this.baseCfs, dataFilter, clause, maxResults, maxIsColumns, false);
        return this.baseCfs.filter(this.getIndexedIterator(range, filter), filter);
    }

    public ColumnFamilyStore.AbstractScanIterator getIndexedIterator(final AbstractBounds<RowPosition> range, final ExtendedFilter filter) {
        final IndexExpression primary = this.highestSelectivityPredicate(filter.getClause());
        final SecondaryIndex index = this.indexManager.getIndexForColumn(primary.column_name);
        if (logger.isDebugEnabled()) {
            logger.debug("Primary scan clause is " + this.baseCfs.getComparator().getString(primary.column_name));
        }
        assert (index != null);
        final DecoratedKey<LocalToken> indexKey = this.indexManager.getIndexKeyFor(primary.column_name, primary.value);
        final ByteBuffer startKey = range.left instanceof DecoratedKey ? ((DecoratedKey)range.left).key : ByteBufferUtil.EMPTY_BYTE_BUFFER;
        final ByteBuffer endKey = range.right instanceof DecoratedKey ? ((DecoratedKey)range.right).key : ByteBufferUtil.EMPTY_BYTE_BUFFER;
        return new ColumnFamilyStore.AbstractScanIterator(){
            private ByteBuffer lastSeenKey;
            private Iterator<IColumn> indexColumns;
            private final QueryPath path;
            private int columnsRead;
            {
                this.lastSeenKey = startKey;
                this.path = new QueryPath(((KeysSearcher)KeysSearcher.this).baseCfs.columnFamily);
                this.columnsRead = Integer.MAX_VALUE;
            }

            protected Row computeNext() {
                DecoratedKey dk;
                int meanColumns = Math.max(index.getIndexCfs().getMeanColumns(), 1);
                int rowsPerQuery = Math.max(Math.min(filter.maxRows(), filter.maxColumns() / meanColumns), 2);
                block0: while (true) {
                    if (this.indexColumns == null || !this.indexColumns.hasNext()) {
                        if (this.columnsRead < rowsPerQuery) {
                            logger.debug("Read only {} (< {}) last page through, must be done", (Object)this.columnsRead, (Object)rowsPerQuery);
                            return (Row)this.endOfData();
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug(String.format("Scanning index %s starting with %s", KeysSearcher.this.expressionString(primary), index.getBaseCfs().metadata.getKeyValidator().getString(startKey)));
                        }
                        QueryFilter indexFilter = QueryFilter.getSliceFilter(indexKey, new QueryPath(index.getIndexCfs().getColumnFamilyName()), this.lastSeenKey, endKey, false, rowsPerQuery);
                        ColumnFamily indexRow = index.getIndexCfs().getColumnFamily(indexFilter);
                        logger.debug("fetched {}", (Object)indexRow);
                        if (indexRow == null) {
                            logger.debug("no data, all done");
                            return (Row)this.endOfData();
                        }
                        Collection<IColumn> sortedColumns = indexRow.getSortedColumns();
                        this.columnsRead = sortedColumns.size();
                        this.indexColumns = sortedColumns.iterator();
                        IColumn firstColumn = sortedColumns.iterator().next();
                        if (this.lastSeenKey != startKey && this.lastSeenKey.equals(firstColumn.name())) {
                            this.indexColumns.next();
                            logger.debug("Skipping {}", (Object)((KeysSearcher)KeysSearcher.this).baseCfs.metadata.getKeyValidator().getString(firstColumn.name()));
                        } else if (range instanceof Range && this.indexColumns.hasNext() && firstColumn.name().equals(startKey)) {
                            this.indexColumns.next();
                            logger.debug("Skipping first key as range excludes it");
                        }
                    }
                    while (true) {
                        if (!this.indexColumns.hasNext()) continue block0;
                        IColumn column = this.indexColumns.next();
                        this.lastSeenKey = column.name();
                        if (column.isMarkedForDelete()) {
                            logger.debug("skipping {}", (Object)column.name());
                            continue;
                        }
                        dk = ((KeysSearcher)KeysSearcher.this).baseCfs.partitioner.decorateKey(this.lastSeenKey);
                        if (!((RowPosition)range.right).isMinimum(((KeysSearcher)KeysSearcher.this).baseCfs.partitioner) && ((RowPosition)range.right).compareTo(dk) < 0) {
                            logger.debug("Reached end of assigned scan range");
                            return (Row)this.endOfData();
                        }
                        if (range.contains(dk)) break block0;
                        logger.debug("Skipping entry {} outside of assigned scan range", dk.token);
                    }
                    break;
                }
                logger.debug("Returning index hit for {}", dk);
                ColumnFamily data = KeysSearcher.this.baseCfs.getColumnFamily(new QueryFilter(dk, this.path, filter.initialFilter()));
                if (data == null) {
                    data = ColumnFamily.create(((KeysSearcher)KeysSearcher.this).baseCfs.metadata);
                }
                return new Row(dk, data);
            }

            @Override
            public void close() throws IOException {
            }
        };
    }
}

