/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.cache.InstrumentingCache;
import org.apache.cassandra.cache.KeyCacheKey;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.DataTracker;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.commitlog.ReplayPosition;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.index.keys.KeysIndex;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.dht.LocalToken;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.compress.CompressedRandomAccessReader;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.sstable.BloomFilterTracker;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.IndexSummary;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableBoundedScanner;
import org.apache.cassandra.io.sstable.SSTableDeletingTask;
import org.apache.cassandra.io.sstable.SSTableMetadata;
import org.apache.cassandra.io.sstable.SSTableScanner;
import org.apache.cassandra.io.util.CompressedSegmentedFile;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.io.util.SegmentedFile;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.BloomFilter;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.CLibrary;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Filter;
import org.apache.cassandra.utils.LegacyBloomFilter;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSTableReader
extends SSTable {
    private static final Logger logger = LoggerFactory.getLogger(SSTableReader.class);
    private static final int INDEX_FILE_BUFFER_BYTES = 16 * DatabaseDescriptor.getIndexInterval();
    public final long maxDataAge;
    private SegmentedFile ifile;
    private SegmentedFile dfile;
    private IndexSummary indexSummary;
    private Filter bf;
    private InstrumentingCache<KeyCacheKey, Long> keyCache;
    private BloomFilterTracker bloomFilterTracker = new BloomFilterTracker();
    private final AtomicInteger references = new AtomicInteger(1);
    private final AtomicBoolean isCompacted = new AtomicBoolean(false);
    private final AtomicBoolean isSuspect = new AtomicBoolean(false);
    private final SSTableDeletingTask deletingTask;
    private final SSTableMetadata sstableMetadata;

    public static long getApproximateKeyCount(Iterable<SSTableReader> sstables) {
        long count = 0L;
        for (SSTableReader sstable : sstables) {
            int indexKeyCount = sstable.getKeySamples().size();
            count += (long)((indexKeyCount + 1) * DatabaseDescriptor.getIndexInterval());
            if (!logger.isDebugEnabled()) continue;
            logger.debug("index size for bloom filter calc for file  : " + sstable.getFilename() + "   : " + count);
        }
        return count;
    }

    public static SSTableReader open(Descriptor descriptor) throws IOException {
        CFMetaData metadata;
        if (descriptor.cfname.contains(".")) {
            int i = descriptor.cfname.indexOf(".");
            String parentName = descriptor.cfname.substring(0, i);
            CFMetaData parent = Schema.instance.getCFMetaData(descriptor.ksname, parentName);
            ColumnDefinition def = parent.getColumnDefinitionForIndex(descriptor.cfname.substring(i + 1));
            metadata = CFMetaData.newIndexMetadata(parent, def, KeysIndex.indexComparator());
        } else {
            metadata = Schema.instance.getCFMetaData(descriptor.ksname, descriptor.cfname);
        }
        return SSTableReader.open(descriptor, metadata);
    }

    public static SSTableReader open(Descriptor desc, CFMetaData metadata) throws IOException {
        IPartitioner<LocalToken> p = desc.cfname.contains(".") ? new LocalPartitioner(metadata.getKeyValidator()) : StorageService.getPartitioner();
        return SSTableReader.open(desc, SSTableReader.componentsFor(desc), metadata, p);
    }

    public static SSTableReader openNoValidation(Descriptor descriptor, Set<Component> components, CFMetaData metadata) throws IOException {
        return SSTableReader.open(descriptor, components, Collections.<DecoratedKey>emptySet(), metadata, StorageService.getPartitioner(), false);
    }

    public static SSTableReader open(Descriptor descriptor, Set<Component> components, CFMetaData metadata, IPartitioner partitioner) throws IOException {
        return SSTableReader.open(descriptor, components, Collections.<DecoratedKey>emptySet(), metadata, partitioner);
    }

    public static SSTableReader open(Descriptor descriptor, Set<Component> components, Set<DecoratedKey> savedKeys, CFMetaData metadata, IPartitioner partitioner) throws IOException {
        return SSTableReader.open(descriptor, components, savedKeys, metadata, partitioner, true);
    }

    private static SSTableReader open(Descriptor descriptor, Set<Component> components, Set<DecoratedKey> savedKeys, CFMetaData metadata, IPartitioner partitioner, boolean validate) throws IOException {
        assert (partitioner != null);
        assert (components.contains(Component.DATA)) : "Data component is missing for sstable" + descriptor;
        assert (components.contains(Component.PRIMARY_INDEX)) : "Primary index component is missing for sstable " + descriptor;
        long start = System.currentTimeMillis();
        logger.info("Opening {} ({} bytes)", (Object)descriptor, (Object)new File(descriptor.filenameFor(COMPONENT_DATA)).length());
        SSTableMetadata sstableMetadata = components.contains(Component.STATS) ? SSTableMetadata.serializer.deserialize(descriptor) : SSTableMetadata.createDefaultInstance();
        String partitionerName = partitioner.getClass().getCanonicalName();
        if (sstableMetadata.partitioner != null && !partitionerName.equals(sstableMetadata.partitioner)) {
            throw new RuntimeException(String.format("Cannot open %s because partitioner does not match %s", descriptor, partitionerName));
        }
        SSTableReader sstable = new SSTableReader(descriptor, components, metadata, partitioner, null, null, null, null, System.currentTimeMillis(), sstableMetadata);
        if (descriptor.hasStringsInBloomFilter) {
            sstable.load(true, savedKeys);
        } else {
            sstable.load(false, savedKeys);
            sstable.loadBloomFilter();
        }
        if (validate) {
            sstable.validate();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("INDEX LOAD TIME for " + descriptor + ": " + (System.currentTimeMillis() - start) + " ms.");
        }
        if (logger.isDebugEnabled() && sstable.getKeyCache() != null) {
            logger.debug(String.format("key cache contains %s/%s keys", sstable.getKeyCache().size(), sstable.getKeyCache().getCapacity()));
        }
        return sstable;
    }

    public static void logOpenException(Descriptor descriptor, IOException e) {
        if (e instanceof FileNotFoundException) {
            logger.error("Missing sstable component in " + descriptor + "; skipped because of " + e.getMessage());
        } else {
            logger.error("Corrupt sstable " + descriptor + "; skipped", (Throwable)e);
        }
    }

    public static Collection<SSTableReader> batchOpen(Set<Map.Entry<Descriptor, Set<Component>>> entries, final Set<DecoratedKey> savedKeys, DataTracker tracker, final CFMetaData metadata, final IPartitioner partitioner) {
        final LinkedBlockingQueue<SSTableReader> sstables = new LinkedBlockingQueue<SSTableReader>();
        DebuggableThreadPoolExecutor executor = DebuggableThreadPoolExecutor.createWithFixedPoolSize("SSTableBatchOpen", FBUtilities.getAvailableProcessors());
        for (final Map.Entry<Descriptor, Set<Component>> entry : entries) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    SSTableReader sstable;
                    try {
                        sstable = SSTableReader.open((Descriptor)entry.getKey(), (Set)entry.getValue(), savedKeys, metadata, partitioner);
                    }
                    catch (IOException ex) {
                        logger.error("Corrupt sstable " + entry + "; skipped", (Throwable)ex);
                        return;
                    }
                    sstables.add(sstable);
                }
            };
            executor.submit(runnable);
        }
        executor.shutdown();
        try {
            executor.awaitTermination(7L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        return sstables;
    }

    static SSTableReader internalOpen(Descriptor desc, Set<Component> components, CFMetaData metadata, IPartitioner partitioner, SegmentedFile ifile, SegmentedFile dfile, IndexSummary isummary, Filter bf, long maxDataAge, SSTableMetadata sstableMetadata) throws IOException {
        assert (desc != null && partitioner != null && ifile != null && dfile != null && isummary != null && bf != null && sstableMetadata != null);
        return new SSTableReader(desc, components, metadata, partitioner, ifile, dfile, isummary, bf, maxDataAge, sstableMetadata);
    }

    private SSTableReader(Descriptor desc, Set<Component> components, CFMetaData metadata, IPartitioner partitioner, SegmentedFile ifile, SegmentedFile dfile, IndexSummary indexSummary, Filter bloomFilter, long maxDataAge, SSTableMetadata sstableMetadata) throws IOException {
        super(desc, components, metadata, partitioner);
        this.sstableMetadata = sstableMetadata;
        this.maxDataAge = maxDataAge;
        this.ifile = ifile;
        this.dfile = dfile;
        this.indexSummary = indexSummary;
        this.bf = bloomFilter;
        this.deletingTask = new SSTableDeletingTask(this);
    }

    public void setTrackedBy(DataTracker tracker) {
        this.keyCache = CacheService.instance.keyCache;
        this.deletingTask.setTracker(tracker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadBloomFilter() throws IOException {
        if (!this.components.contains(Component.FILTER)) {
            this.bf = BloomFilter.emptyFilter();
            return;
        }
        DataInputStream stream = null;
        try {
            stream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.descriptor.filenameFor(Component.FILTER))));
            this.bf = this.descriptor.usesOldBloomFilter ? LegacyBloomFilter.serializer().deserialize(stream) : BloomFilter.serializer().deserialize(stream);
        }
        catch (Throwable throwable) {
            FileUtils.closeQuietly(stream);
            throw throwable;
        }
        FileUtils.closeQuietly(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(boolean recreatebloom, Set<DecoratedKey> keysToLoadInCache) throws IOException {
        boolean cacheLoading = this.keyCache != null && !keysToLoadInCache.isEmpty();
        SegmentedFile.Builder ibuilder = SegmentedFile.getBuilder(DatabaseDescriptor.getIndexAccessMode());
        SegmentedFile.Builder dbuilder = this.compression ? SegmentedFile.getCompressedBuilder() : SegmentedFile.getBuilder(DatabaseDescriptor.getDiskAccessMode());
        RandomAccessReader input = RandomAccessReader.open(new File(this.descriptor.filenameFor(Component.PRIMARY_INDEX)), true);
        DecoratedKey left = null;
        DecoratedKey right = null;
        try {
            long indexPosition;
            long indexSize = input.length();
            long histogramCount = this.sstableMetadata.estimatedRowSize.count();
            long estimatedKeys = histogramCount > 0L && !this.sstableMetadata.estimatedRowSize.isOverflowed() ? histogramCount : SSTable.estimateRowsFromIndex(input);
            this.indexSummary = new IndexSummary(estimatedKeys);
            if (recreatebloom) {
                this.bf = LegacyBloomFilter.getFilter(estimatedKeys, 15);
            }
            while ((indexPosition = input.getFilePointer()) != indexSize) {
                DecoratedKey decoratedKey = null;
                int len = ByteBufferUtil.readShortLength(input);
                boolean firstKey = left == null;
                boolean lastKey = indexPosition + 2L + (long)len + 8L == indexSize;
                boolean shouldAddEntry = this.indexSummary.shouldAddEntry();
                if (shouldAddEntry || cacheLoading || recreatebloom || firstKey || lastKey) {
                    decoratedKey = SSTableReader.decodeKey(this.partitioner, this.descriptor, ByteBufferUtil.read(input, len));
                    if (firstKey) {
                        left = decoratedKey;
                    }
                    if (lastKey) {
                        right = decoratedKey;
                    }
                } else {
                    FileUtils.skipBytesFully((DataInput)input, len);
                }
                long dataPosition = input.readLong();
                if (decoratedKey != null) {
                    if (recreatebloom) {
                        this.bf.add(decoratedKey.key);
                    }
                    if (shouldAddEntry) {
                        this.indexSummary.addEntry(decoratedKey, indexPosition);
                    }
                    if (cacheLoading && keysToLoadInCache.contains(decoratedKey)) {
                        this.cacheKey(decoratedKey, dataPosition);
                    }
                }
                this.indexSummary.incrementRowid();
                ibuilder.addPotentialBoundary(indexPosition);
                dbuilder.addPotentialBoundary(dataPosition);
            }
            this.indexSummary.complete();
        }
        finally {
            FileUtils.closeQuietly(input);
        }
        this.first = SSTableReader.getMinimalKey(left);
        this.last = SSTableReader.getMinimalKey(right);
        this.ifile = ibuilder.complete(this.descriptor.filenameFor(Component.PRIMARY_INDEX));
        this.dfile = dbuilder.complete(this.descriptor.filenameFor(Component.DATA));
    }

    private void validate() {
        if (this.first.compareTo(this.last) > 0) {
            throw new IllegalStateException(String.format("SSTable first key %s > last key %s", this.first, this.last));
        }
    }

    private long getIndexScanPosition(RowPosition key) {
        assert (this.indexSummary.getKeys() != null && this.indexSummary.getKeys().size() > 0);
        int index = Collections.binarySearch(this.indexSummary.getKeys(), key);
        if (index < 0) {
            int greaterThan = (index + 1) * -1;
            if (greaterThan == 0) {
                return -1L;
            }
            return this.indexSummary.getPosition(greaterThan - 1);
        }
        return this.indexSummary.getPosition(index);
    }

    public CompressionMetadata getCompressionMetadata() {
        if (!this.compression) {
            throw new IllegalStateException(this + " is not compressed");
        }
        return ((CompressedSegmentedFile)this.dfile).metadata;
    }

    public void forceFilterFailures() {
        this.bf = LegacyBloomFilter.alwaysMatchingBloomFilter();
    }

    public Filter getBloomFilter() {
        return this.bf;
    }

    public long getBloomFilterSerializedSize() {
        if (this.descriptor.usesOldBloomFilter) {
            return LegacyBloomFilter.serializer().serializedSize((LegacyBloomFilter)this.bf);
        }
        return BloomFilter.serializer().serializedSize((BloomFilter)this.bf);
    }

    public long estimatedKeys() {
        return this.indexSummary.getKeys().size() * DatabaseDescriptor.getIndexInterval();
    }

    public long estimatedKeysForRanges(Collection<Range<Token>> ranges) {
        long sampleKeyCount = 0L;
        List<Pair<Integer, Integer>> sampleIndexes = SSTableReader.getSampleIndexesForRanges(this.indexSummary.getKeys(), ranges);
        for (Pair<Integer, Integer> sampleIndexRange : sampleIndexes) {
            sampleKeyCount += (long)((Integer)sampleIndexRange.right - (Integer)sampleIndexRange.left + 1);
        }
        return Math.max(1L, sampleKeyCount * (long)DatabaseDescriptor.getIndexInterval().intValue());
    }

    public Collection<DecoratedKey<?>> getKeySamples() {
        return this.indexSummary.getKeys();
    }

    private static List<Pair<Integer, Integer>> getSampleIndexesForRanges(List<DecoratedKey<?>> samples, Collection<Range<Token>> ranges) {
        ArrayList<Pair<Integer, Integer>> positions = new ArrayList<Pair<Integer, Integer>>();
        if (samples.isEmpty()) {
            return positions;
        }
        for (Range range : Range.normalize(ranges)) {
            int right;
            Token.KeyBound leftPosition = ((Token)range.left).maxKeyBound();
            Token.KeyBound rightPosition = ((Token)range.right).maxKeyBound();
            int left = Collections.binarySearch(samples, leftPosition);
            left = left < 0 ? (left + 1) * -1 : ++left;
            if (left == samples.size()) continue;
            int n = right = Range.isWrapAround(range.left, range.right) ? samples.size() - 1 : Collections.binarySearch(samples, rightPosition);
            if (right < 0) {
                if ((right = (right + 1) * -1) == 0) continue;
                --right;
            }
            if (left > right) continue;
            positions.add(new Pair<Integer, Integer>(left, right));
        }
        return positions;
    }

    public Iterable<DecoratedKey<?>> getKeySamples(Range<Token> range) {
        final List<DecoratedKey<?>> samples = this.indexSummary.getKeys();
        final List<Pair<Integer, Integer>> indexRanges = SSTableReader.getSampleIndexesForRanges(samples, Collections.singletonList(range));
        if (indexRanges.isEmpty()) {
            return Collections.emptyList();
        }
        return new Iterable<DecoratedKey<?>>(){

            @Override
            public Iterator<DecoratedKey<?>> iterator() {
                return new Iterator<DecoratedKey<?>>(){
                    private Iterator<Pair<Integer, Integer>> rangeIter;
                    private Pair<Integer, Integer> current;
                    private int idx;
                    {
                        this.rangeIter = indexRanges.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.current == null || this.idx > (Integer)this.current.right) {
                            if (this.rangeIter.hasNext()) {
                                this.current = this.rangeIter.next();
                                this.idx = (Integer)this.current.left;
                                return true;
                            }
                            return false;
                        }
                        return true;
                    }

                    @Override
                    public DecoratedKey next() {
                        RowPosition k = (RowPosition)samples.get(this.idx++);
                        assert (k instanceof DecoratedKey);
                        return (DecoratedKey)k;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public List<Pair<Long, Long>> getPositionsForRanges(Collection<Range<Token>> ranges) {
        ArrayList<Pair<Long, Long>> positions = new ArrayList<Pair<Long, Long>>();
        for (Range range : Range.normalize(ranges)) {
            AbstractBounds<RowPosition> keyRange = range.toRowBounds();
            long left = this.getPosition((RowPosition)keyRange.left, Operator.GT);
            if (left == -1L) continue;
            long right = this.getPosition((RowPosition)keyRange.right, Operator.GT);
            if (right == -1L || Range.isWrapAround(range.left, range.right)) {
                right = this.uncompressedLength();
            }
            if (left == right) continue;
            positions.add(new Pair<Long, Long>(left, right));
        }
        return positions;
    }

    public void cacheKey(DecoratedKey key, Long info) {
        CFMetaData.Caching caching = this.metadata.getCaching();
        if (this.keyCache == null || caching == CFMetaData.Caching.NONE || caching == CFMetaData.Caching.ROWS_ONLY || this.keyCache.getCapacity() == 0L) {
            return;
        }
        KeyCacheKey cacheKey = new KeyCacheKey(this.descriptor, ByteBufferUtil.clone(key.key));
        logger.trace("Adding cache entry for {} -> {}", (Object)cacheKey, (Object)info);
        this.keyCache.put(cacheKey, info);
    }

    public Long getCachedPosition(DecoratedKey key, boolean updateStats) {
        return this.getCachedPosition(new KeyCacheKey(this.descriptor, key.key), updateStats);
    }

    private Long getCachedPosition(KeyCacheKey unifiedKey, boolean updateStats) {
        if (this.keyCache != null && this.keyCache.getCapacity() > 0L) {
            return updateStats ? this.keyCache.get(unifiedKey) : this.keyCache.getInternal(unifiedKey);
        }
        return null;
    }

    public long getPosition(RowPosition key, Operator op) {
        return this.getPosition(key, op, true);
    }

    public long getPosition(RowPosition key, Operator op, boolean updateCacheAndStats) {
        long sampledPosition;
        if (op == Operator.EQ) {
            assert (key instanceof DecoratedKey);
            if (!this.bf.isPresent(((DecoratedKey)key).key)) {
                return -1L;
            }
        }
        if ((op == Operator.EQ || op == Operator.GE) && key instanceof DecoratedKey) {
            DecoratedKey decoratedKey = (DecoratedKey)key;
            KeyCacheKey cacheKey = new KeyCacheKey(this.descriptor, decoratedKey.key);
            Long cachedPosition = this.getCachedPosition(cacheKey, updateCacheAndStats);
            if (cachedPosition != null) {
                logger.trace("Cache hit for {} -> {}", (Object)cacheKey, (Object)cachedPosition);
                return cachedPosition;
            }
        }
        if ((sampledPosition = this.getIndexScanPosition(key)) == -1L) {
            if (op == Operator.EQ && updateCacheAndStats) {
                this.bloomFilterTracker.addFalsePositive();
            }
            return op.apply(1) >= 0 ? 0L : -1L;
        }
        Iterator<FileDataInput> segments = this.ifile.iterator(sampledPosition, INDEX_FILE_BUFFER_BYTES);
        while (segments.hasNext()) {
            FileDataInput input = segments.next();
            try {
                while (!input.isEOF()) {
                    DecoratedKey indexDecoratedKey = SSTableReader.decodeKey(this.partitioner, this.descriptor, ByteBufferUtil.readWithShortLength(input));
                    long dataPosition = input.readLong();
                    int comparison = indexDecoratedKey.compareTo(key);
                    int v = op.apply(comparison);
                    if (v == 0) {
                        if (comparison == 0) {
                            assert (key instanceof DecoratedKey);
                            DecoratedKey decoratedKey = (DecoratedKey)key;
                            if (logger.isTraceEnabled()) {
                                FileDataInput fdi = this.dfile.getSegment(dataPosition);
                                DecoratedKey keyInDisk = SSTableReader.decodeKey(this.partitioner, this.descriptor, ByteBufferUtil.readWithShortLength(fdi));
                                if (!keyInDisk.equals(key)) {
                                    throw new AssertionError((Object)String.format("%s != %s in %s", keyInDisk, key, fdi.getPath()));
                                }
                                fdi.close();
                            }
                            if (this.keyCache != null && this.keyCache.getCapacity() > 0L && updateCacheAndStats) {
                                this.cacheKey(decoratedKey, dataPosition);
                            }
                        }
                        if (op == Operator.EQ && updateCacheAndStats) {
                            this.bloomFilterTracker.addTruePositive();
                        }
                        long l = dataPosition;
                        return l;
                    }
                    if (v >= 0) continue;
                    if (op == Operator.EQ && updateCacheAndStats) {
                        this.bloomFilterTracker.addFalsePositive();
                    }
                    long l = -1L;
                    return l;
                }
            }
            catch (IOException e) {
                this.markSuspect();
                throw new IOError(e);
            }
            finally {
                FileUtils.closeQuietly(input);
            }
        }
        if (op == Operator.EQ && updateCacheAndStats) {
            this.bloomFilterTracker.addFalsePositive();
        }
        return -1L;
    }

    public long uncompressedLength() {
        return this.dfile.length;
    }

    public long onDiskLength() {
        return this.dfile.onDiskLength;
    }

    public boolean acquireReference() {
        int n;
        do {
            if ((n = this.references.get()) > 0) continue;
            return false;
        } while (!this.references.compareAndSet(n, n + 1));
        return true;
    }

    public void releaseReference() {
        if (this.references.decrementAndGet() == 0 && this.isCompacted.get()) {
            this.ifile.cleanup();
            this.dfile.cleanup();
            this.deletingTask.schedule();
        }
        assert (this.references.get() >= 0) : "Reference counter " + this.references.get() + " for " + this.dfile.path;
    }

    public boolean markCompacted() {
        if (logger.isDebugEnabled()) {
            logger.debug("Marking " + this.getFilename() + " compacted");
        }
        return !this.isCompacted.getAndSet(true);
    }

    public void markSuspect() {
        if (logger.isDebugEnabled()) {
            logger.debug("Marking " + this.getFilename() + " as a suspect for blacklisting.");
        }
        this.isSuspect.getAndSet(true);
    }

    public boolean isMarkedSuspect() {
        return this.isSuspect.get();
    }

    public SSTableScanner getScanner(QueryFilter filter) {
        return new SSTableScanner(this, filter);
    }

    public SSTableScanner getDirectScanner() {
        return new SSTableScanner(this, true);
    }

    public SSTableScanner getDirectScanner(Range<Token> range) {
        if (range == null) {
            return this.getDirectScanner();
        }
        return new SSTableBoundedScanner(this, true, range);
    }

    public FileDataInput getFileDataInput(DecoratedKey decoratedKey) {
        long position = this.getPosition(decoratedKey, Operator.EQ);
        if (position < 0L) {
            return null;
        }
        return this.dfile.getSegment(position);
    }

    public boolean newSince(long age) {
        return this.maxDataAge > age;
    }

    public static long readRowSize(DataInput in, Descriptor d) throws IOException {
        if (d.hasIntRowSize) {
            return in.readInt();
        }
        return in.readLong();
    }

    public void createLinks(String snapshotDirectoryPath) throws IOException {
        for (Component component : this.components) {
            File sourceFile = new File(this.descriptor.filenameFor(component));
            File targetLink = new File(snapshotDirectoryPath, sourceFile.getName());
            CLibrary.createHardLink(sourceFile, targetLink);
        }
    }

    public static DecoratedKey decodeKey(IPartitioner p, Descriptor d, ByteBuffer bytes) {
        if (d.hasEncodedKeys) {
            return p.convertFromDiskFormat(bytes);
        }
        return p.decorateKey(bytes);
    }

    public long getBloomFilterFalsePositiveCount() {
        return this.bloomFilterTracker.getFalsePositiveCount();
    }

    public long getRecentBloomFilterFalsePositiveCount() {
        return this.bloomFilterTracker.getRecentFalsePositiveCount();
    }

    public long getBloomFilterTruePositiveCount() {
        return this.bloomFilterTracker.getTruePositiveCount();
    }

    public long getRecentBloomFilterTruePositiveCount() {
        return this.bloomFilterTracker.getRecentTruePositiveCount();
    }

    public InstrumentingCache<KeyCacheKey, Long> getKeyCache() {
        return this.keyCache;
    }

    public EstimatedHistogram getEstimatedRowSize() {
        return this.sstableMetadata.estimatedRowSize;
    }

    public EstimatedHistogram getEstimatedColumnCount() {
        return this.sstableMetadata.estimatedColumnCount;
    }

    public double getCompressionRatio() {
        return this.sstableMetadata.compressionRatio;
    }

    public ReplayPosition getReplayPosition() {
        return this.sstableMetadata.replayPosition;
    }

    public long getMaxTimestamp() {
        return this.sstableMetadata.maxTimestamp;
    }

    public Set<Integer> getAncestors() {
        return this.sstableMetadata.ancestors;
    }

    public RandomAccessReader openDataReader(boolean skipIOCache) throws IOException {
        return this.compression ? CompressedRandomAccessReader.open(this.getFilename(), this.getCompressionMetadata(), skipIOCache) : RandomAccessReader.open(new File(this.getFilename()), skipIOCache);
    }

    public static boolean acquireReferences(Iterable<SSTableReader> sstables) {
        SSTableReader failed = null;
        for (SSTableReader sstable : sstables) {
            if (sstable.acquireReference()) continue;
            failed = sstable;
            break;
        }
        if (failed == null) {
            return true;
        }
        for (SSTableReader sstable : sstables) {
            if (sstable == failed) break;
            sstable.releaseReference();
        }
        return false;
    }

    public static void releaseReferences(Iterable<SSTableReader> sstables) {
        for (SSTableReader sstable : sstables) {
            try {
                sstable.releaseReference();
            }
            catch (Exception ex) {
                logger.error("Failed releasing reference on " + sstable, (Throwable)ex);
            }
        }
    }

    public static abstract class Operator {
        public static final Operator EQ = new Equals();
        public static final Operator GE = new GreaterThanOrEqualTo();
        public static final Operator GT = new GreaterThan();

        public abstract int apply(int var1);

        static final class GreaterThan
        extends Operator {
            GreaterThan() {
            }

            @Override
            public int apply(int comparison) {
                return comparison > 0 ? 0 : 1;
            }
        }

        static final class GreaterThanOrEqualTo
        extends Operator {
            GreaterThanOrEqualTo() {
            }

            @Override
            public int apply(int comparison) {
                return comparison >= 0 ? 0 : -comparison;
            }
        }

        static final class Equals
        extends Operator {
            Equals() {
            }

            @Override
            public int apply(int comparison) {
                return -comparison;
            }
        }
    }
}

