/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import org.apache.cassandra.auth.IAuthenticator;
import org.apache.cassandra.auth.IAuthorizer;
import org.apache.cassandra.auth.MigrationListener;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.service.MigrationManager;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Auth {
    private static final Logger logger = LoggerFactory.getLogger(Auth.class);
    public static final String DEFAULT_SUPERUSER_NAME = "cassandra";
    public static final String AUTH_KS = "system_auth";
    public static final String USERS_CF = "users";

    public static boolean isExistingUser(String username) {
        String query = String.format("SELECT * FROM %s.%s WHERE name = '%s'", AUTH_KS, USERS_CF, Auth.escape(username));
        try {
            return !QueryProcessor.process(query).isEmpty();
        }
        catch (RequestExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isSuperuser(String username) {
        String query = String.format("SELECT super FROM %s.%s WHERE name = '%s'", AUTH_KS, USERS_CF, Auth.escape(username));
        try {
            UntypedResultSet result = QueryProcessor.process(query);
            return !result.isEmpty() && result.one().getBoolean("super");
        }
        catch (RequestExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static void insertUser(String username, boolean isSuper) throws RequestExecutionException {
        QueryProcessor.process(String.format("INSERT INTO %s.%s (name, super) VALUES ('%s', %s)", AUTH_KS, USERS_CF, Auth.escape(username), isSuper));
    }

    public static void deleteUser(String username) throws RequestExecutionException {
        QueryProcessor.process(String.format("DELETE FROM %s.%s WHERE name = '%s'", AUTH_KS, USERS_CF, Auth.escape(username)));
    }

    public static void setup() {
        Auth.authenticator().setup();
        Auth.authorizer().setup();
        MigrationManager.instance.register(new MigrationListener());
    }

    public static void setupSuperuser() {
        try {
            if (QueryProcessor.process(String.format("SELECT * FROM %s.%s", AUTH_KS, USERS_CF)).isEmpty()) {
                Auth.insertUser(DEFAULT_SUPERUSER_NAME, true);
            }
        }
        catch (RequestExecutionException e) {
            logger.warn("Skipping default superuser setup: some nodes are not ready");
        }
    }

    private static String escape(String name) {
        return StringUtils.replace((String)name, (String)"'", (String)"''");
    }

    private static IAuthenticator authenticator() {
        return DatabaseDescriptor.getAuthenticator();
    }

    private static IAuthorizer authorizer() {
        return DatabaseDescriptor.getAuthorizer();
    }
}

