/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.DeletedColumn;
import org.apache.cassandra.db.ExpiringColumn;
import org.apache.cassandra.db.RangeTombstone;

public class UpdateParameters {
    public final List<ByteBuffer> variables;
    public final long timestamp;
    private final int ttl;
    public final int localDeletionTime;

    public UpdateParameters(List<ByteBuffer> variables, long timestamp, int ttl) {
        this.variables = variables;
        this.timestamp = timestamp;
        this.ttl = ttl;
        this.localDeletionTime = (int)(System.currentTimeMillis() / 1000L);
    }

    public Column makeColumn(ByteBuffer name, ByteBuffer value) {
        return this.ttl > 0 ? new ExpiringColumn(name, value, this.timestamp, this.ttl) : new Column(name, value, this.timestamp);
    }

    public Column makeTombstone(ByteBuffer name) {
        return new DeletedColumn(name, this.localDeletionTime, this.timestamp);
    }

    public RangeTombstone makeRangeTombstone(ByteBuffer start, ByteBuffer end) {
        return new RangeTombstone(start, end, this.timestamp, this.localDeletionTime);
    }

    public RangeTombstone makeTombstoneForOverwrite(ByteBuffer start, ByteBuffer end) {
        return new RangeTombstone(start, end, this.timestamp - 1L, this.localDeletionTime);
    }
}

